/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.impl.helpers;

import com.atlassian.plugin.cache.filecache.Cache;
import com.atlassian.plugin.servlet.DownloadException;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.QueryParams;
import com.atlassian.plugin.webresource.WebResourceTransformation;
import com.atlassian.plugin.webresource.impl.CachedTransformers;
import com.atlassian.plugin.webresource.impl.Globals;
import com.atlassian.plugin.webresource.impl.RequestCache;
import com.atlassian.plugin.webresource.impl.annotators.ResourceContentAnnotator;
import com.atlassian.plugin.webresource.impl.helpers.UrlGenerationHelpers;
import com.atlassian.plugin.webresource.impl.snapshot.Bundle;
import com.atlassian.plugin.webresource.impl.snapshot.Resource;
import com.atlassian.plugin.webresource.impl.snapshot.WebResource;
import com.atlassian.plugin.webresource.impl.support.Content;
import com.atlassian.plugin.webresource.impl.support.ContentImpl;
import com.atlassian.plugin.webresource.impl.support.LineCountingProxyOutputStream;
import com.atlassian.plugin.webresource.impl.support.SourceMapJoinerStub;
import com.atlassian.plugin.webresource.impl.support.Support;
import com.atlassian.plugin.webresource.impl.support.http.BaseRouter;
import com.atlassian.plugin.webresource.transformer.MinificationTransformer;
import com.atlassian.plugin.webresource.transformer.StaticTransformers;
import com.atlassian.sourcemap.SourceMap;
import com.atlassian.sourcemap.SourceMapJoiner;
import com.atlassian.sourcemap.Util;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ResourceServingHelpers
extends UrlGenerationHelpers {
    public static Resource getResource(RequestCache requestCache, String completeKey, String resourceName) {
        Resource resource = ResourceServingHelpers.getWebResourceResource(requestCache, completeKey, resourceName);
        if (resource == null) {
            resource = ResourceServingHelpers.getResourceRelativeToWebResource(requestCache, completeKey, resourceName);
        }
        if (resource == null) {
            resource = ResourceServingHelpers.getModuleResource(requestCache.getGlobals(), completeKey, resourceName);
        }
        if (resource == null) {
            resource = ResourceServingHelpers.getPluginResource(requestCache.getGlobals(), completeKey, resourceName);
        }
        if (resource == null) {
            resource = ResourceServingHelpers.getResourceRelativeToPlugin(requestCache.getGlobals(), completeKey, resourceName);
        }
        return resource;
    }

    public static Resource getResource(RequestCache requestCache, Collection<String> bundles, String resourceName) {
        String key;
        Resource resource = null;
        Iterator<String> iterator = bundles.iterator();
        while (iterator.hasNext() && (resource = ResourceServingHelpers.getResource(requestCache, key = iterator.next(), resourceName)) == null) {
        }
        return resource;
    }

    public static Content transform(final Globals globals, final LinkedHashSet<String> requiredResources, final String url, final String type, final Supplier<Collection<Resource>> resources, final Map<String, String> params) {
        return new ContentImpl(null, true){

            @Override
            public SourceMap writeTo(OutputStream out, boolean isSourceMapEnabled) {
                ResourceContentAnnotator annotator = globals.getConfig().getContentAnnotator(type);
                try {
                    SourceMapJoiner sourceMapJoiner = isSourceMapEnabled ? new SourceMapJoiner() : new SourceMapJoinerStub();
                    boolean isFirst = true;
                    for (Resource resource : (Collection)resources.get()) {
                        if (!isFirst) {
                            out.write(10);
                        }
                        LineCountingProxyOutputStream lineCountingStream = new LineCountingProxyOutputStream(out);
                        OutputStream outOrLineCountingStream = isSourceMapEnabled ? lineCountingStream : out;
                        int offset = 0;
                        if (isFirst) {
                            offset += annotator.beforeAllResourcesInBatch(requiredResources, url, outOrLineCountingStream);
                        }
                        Content content = ResourceServingHelpers.transformSafely(globals, requiredResources, url, resource, params, false);
                        SourceMap sourceMap = content.writeTo(outOrLineCountingStream, isSourceMapEnabled);
                        int resourceLength = lineCountingStream.getLinesCount() - (offset += annotator.beforeResourceInBatch(requiredResources, resource, outOrLineCountingStream));
                        annotator.afterResourceInBatch(requiredResources, resource, outOrLineCountingStream);
                        if (isSourceMapEnabled && sourceMap == null) {
                            String singleResourceUrl = globals.getRouter().resourceUrlWithoutHash(resource, params);
                            sourceMap = Util.create1to1SourceMap((int)resourceLength, (String)singleResourceUrl);
                        }
                        sourceMapJoiner.add(sourceMap, lineCountingStream.getLinesCount(), offset);
                        if (!isFirst) continue;
                        isFirst = false;
                    }
                    annotator.afterAllResourcesInBatch(requiredResources, url, out);
                    return sourceMapJoiner.join();
                }
                catch (IOException e) {
                    Support.logIOException(e);
                    return null;
                }
            }
        };
    }

    public static Content transform(final Globals globals, LinkedHashSet<String> requiredResources, String url, final Resource resource, final Map<String, String> params, boolean applyAnnotators) {
        final Content content = ResourceServingHelpers.transformWithoutCache(globals, requiredResources, url, resource, params, applyAnnotators);
        if (resource.getParent().hasLegacyTransformers() || globals.getConfig().isSourceMapEnabledFor(resource.getNameOrLocationType())) {
            return content;
        }
        return new ContentImpl(content.getContentType(), content.isTransformed()){

            @Override
            public SourceMap writeTo(OutputStream out, final boolean isSourceMapEnabled) {
                if (isSourceMapEnabled) {
                    Support.LOGGER.warn("internal error, source map could not be used with incremental transformer cache!");
                }
                String key = BaseRouter.buildUrl(resource.getKey() + ":" + resource.getName(), params);
                globals.getTemporaryIncrementalCache().cache("transformer", key, out, new Cache.StreamProvider(){

                    @Override
                    public void write(OutputStream out) {
                        content.writeTo(out, isSourceMapEnabled);
                    }
                });
                return null;
            }
        };
    }

    public static String buildKey(Globals globals, Resource resource, Map<String, String> params) {
        if (resource.getParent() instanceof WebResource) {
            WebResource webResource = (WebResource)resource.getParent();
            List<WebResourceTransformation> transformations = webResource.getTransformers().getTransformations();
            HashMap<String, String> usedParameters = new HashMap<String, String>();
            for (WebResourceTransformation transformation : transformations) {
                usedParameters.putAll(transformation.leaveOnlyUsedParameters(globals.getConfig().getTransformerCache(), params));
            }
            for (String key : StaticTransformers.PARAMETERS_USED) {
                if (!params.containsKey(key)) continue;
                usedParameters.put(key, params.get(key));
            }
            return BaseRouter.buildUrl(resource.getKey() + ":" + resource.getName(), usedParameters);
        }
        return resource.getKey();
    }

    public static Content transformWithoutCache(final Globals globals, final LinkedHashSet<String> requiredResources, final String url, final Resource resource, Map<String, String> params, boolean applyAnnotators) {
        Preconditions.checkArgument((!resource.isRedirect() ? 1 : 0) != 0, (Object)"can't transform redirect resource!");
        Content content = resource.getContent();
        if (!resource.isTransformable()) {
            return content;
        }
        String sourceUrl = globals.getRouter().sourceUrl(resource);
        content = MinificationTransformer.minify(globals.getConfig(), resource, content, sourceUrl);
        content = ResourceServingHelpers.applyTransformers(globals, resource, content, params, sourceUrl);
        content = ResourceServingHelpers.applyStaticTransformers(globals, resource, content, params, sourceUrl);
        if (applyAnnotators) {
            final Content immutableContent = content;
            return new ContentImpl(content.getContentType(), true){

                @Override
                public SourceMap writeTo(OutputStream out, boolean isSourceMapEnabled) {
                    ResourceContentAnnotator annotator = globals.getConfig().getContentAnnotator(resource.getNameOrLocationType());
                    try {
                        int offset = annotator.beforeResource(requiredResources, url, resource, out);
                        SourceMap sourceMap = immutableContent.writeTo(out, isSourceMapEnabled);
                        if (isSourceMapEnabled && sourceMap != null) {
                            sourceMap = Util.offset((SourceMap)sourceMap, (int)offset);
                        }
                        annotator.afterResource(requiredResources, url, resource, out);
                        return sourceMap;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }
        return content;
    }

    public static String toString(Content content) {
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        content.writeTo(buff, false);
        return ((Object)buff).toString();
    }

    public static Content transformSafely(Globals globals, LinkedHashSet<String> requiredResources, String url, Resource resource, Map<String, String> params, boolean applyAnnotators) {
        Content content;
        try {
            content = ResourceServingHelpers.transform(globals, requiredResources, url, resource, params, applyAnnotators);
        }
        catch (RuntimeException e) {
            Support.LOGGER.warn("can't transform resource " + resource.getKey() + ":" + resource.getName(), (Throwable)e);
            content = ResourceServingHelpers.buildEmptyContent(null);
        }
        return ResourceServingHelpers.buildSafeContent(content, resource.getFullName());
    }

    public static Predicate<Resource> shouldBeIncludedInBatch(final String type, final Map<String, String> params) {
        return new Predicate<Resource>(){

            public boolean apply(Resource resource) {
                return type.equals(resource.getNameOrLocationType()) && resource.isBatchable(params);
            }
        };
    }

    public static DownloadableResource asDownloadableResource(final Content content) {
        return new DownloadableResource(){

            public boolean isResourceModified(HttpServletRequest request, HttpServletResponse response) {
                throw new RuntimeException("not supported for content wrapper!");
            }

            public void serveResource(HttpServletRequest request, HttpServletResponse response) {
                throw new RuntimeException("not supported for content wrapper!");
            }

            public void streamResource(OutputStream out) {
                content.writeTo(out, false);
            }

            public String getContentType() {
                return content.getContentType();
            }
        };
    }

    public static Content asContent(final DownloadableResource downloadableResource, final SourceMap sourceMap, boolean isTransformed) {
        return new ContentImpl(downloadableResource.getContentType(), isTransformed){

            @Override
            public SourceMap writeTo(OutputStream out, boolean isSourceMapEnabled) {
                try {
                    downloadableResource.streamResource(out);
                }
                catch (DownloadException e) {
                    Support.LOGGER.debug("Error while serving file: DownloadException");
                }
                return sourceMap;
            }
        };
    }

    public static Content buildEmptyContent(String contentType) {
        return new ContentImpl(contentType, false){

            @Override
            public SourceMap writeTo(OutputStream out, boolean isSourceMapEnabled) {
                return null;
            }
        };
    }

    public static Content buildSafeContent(final Content content, final String fullResourceName) {
        return new Content(){

            @Override
            public SourceMap writeTo(OutputStream out, boolean isSourceMapEnabled) {
                try {
                    return content.writeTo(out, isSourceMapEnabled);
                }
                catch (RuntimeException e) {
                    Support.LOGGER.warn("error in `Content.writeTo` for " + fullResourceName, (Throwable)e);
                    return null;
                }
            }

            @Override
            public String getContentType() {
                try {
                    return content.getContentType();
                }
                catch (RuntimeException e) {
                    Support.LOGGER.warn("error in `Content.getContentType` for " + fullResourceName, (Throwable)e);
                    return null;
                }
            }

            @Override
            public boolean isTransformed() {
                try {
                    return content.isTransformed();
                }
                catch (RuntimeException e) {
                    Support.LOGGER.warn("error in `Content.isTransformed` for " + fullResourceName, (Throwable)e);
                    return false;
                }
            }
        };
    }

    protected static Content applyTransformers(Globals globals, Resource resource, Content content, Map<String, String> params, String sourceUrl) {
        if (resource.getParent() instanceof WebResource) {
            WebResource webResource = (WebResource)resource.getParent();
            CachedTransformers transformers = webResource.getTransformers();
            if (transformers == null) {
                return content;
            }
            Content lastContent = content;
            for (WebResourceTransformation transformation : transformers.getTransformations()) {
                if (!transformation.matches(resource.getResourceLocation())) continue;
                lastContent = transformation.transform(globals.getConfig().getCdnResourceUrlTransformer(), globals.getConfig().getTransformerCache(), resource, lastContent, resource.getResourceLocation(), resource.getFilePath(), QueryParams.of(params), sourceUrl);
            }
            return lastContent;
        }
        return content;
    }

    protected static Content applyStaticTransformers(Globals globals, Resource resource, Content content, Map<String, String> params, String sourceUrl) {
        if (resource.getParent() instanceof WebResource) {
            return globals.getConfig().getStaticTransformers().transform(content, resource.getParent().getTransformerParameters(), resource.getResourceLocation(), resource.getFilePath(), QueryParams.of(params), sourceUrl);
        }
        return content;
    }

    protected static Resource getWebResourceResource(RequestCache requestCache, String completeKey, String resourceName) {
        Bundle bundle = requestCache.getSnapshot().get(completeKey);
        if (bundle == null) {
            return null;
        }
        return bundle.getResources(requestCache).get(resourceName);
    }

    public static Resource getModuleResource(Globals globals, String completeKeyOrPluginKey, String resourceName) {
        return globals.getConfig().getModuleResource(completeKeyOrPluginKey, resourceName);
    }

    @Deprecated
    protected static Resource getResourceRelativeToWebResource(RequestCache requestCache, String completeKey, String resourceName) {
        Bundle bundle = requestCache.getSnapshot().get(completeKey);
        if (bundle == null) {
            return null;
        }
        String filePath = "";
        Resource resource = null;
        while (resource == null) {
            String[] parts = ResourceServingHelpers.splitLastPathPart(resourceName);
            if (parts == null) {
                return null;
            }
            resourceName = parts[0];
            filePath = parts[1] + filePath;
            resource = bundle.getResources(requestCache).get(resourceName);
        }
        final String finalFilePath = filePath;
        return new Resource(resource.getParent(), resource.getResourceLocation(), resource.getNameType(), resource.getLocationType()){

            @Override
            public String getFilePath() {
                return finalFilePath;
            }
        };
    }

    protected static Resource getPluginResource(Globals globals, String completeKeyOrPluginKey, String resourceName) {
        return globals.getConfig().getPluginResource(ResourceServingHelpers.getPluginKey(completeKeyOrPluginKey), resourceName);
    }

    @Deprecated
    protected static Resource getResourceRelativeToPlugin(Globals globals, String completeKeyOrPluginKey, String resourceName) {
        String pluginKey = ResourceServingHelpers.getPluginKey(completeKeyOrPluginKey);
        String filePath = "";
        Resource resource = null;
        while (resource == null) {
            String[] parts = ResourceServingHelpers.splitLastPathPart(resourceName);
            if (parts == null) {
                return null;
            }
            resourceName = parts[0];
            filePath = parts[1] + filePath;
            resource = globals.getConfig().getPluginResource(pluginKey, resourceName);
        }
        final String finalFilePath = filePath;
        return new Resource(resource.getParent(), resource.getResourceLocation(), resource.getNameType(), resource.getLocationType()){

            @Override
            public String getFilePath() {
                return finalFilePath;
            }
        };
    }

    @Deprecated
    public static String[] splitLastPathPart(String resourcePath) {
        int indexOfSlash = resourcePath.lastIndexOf(47);
        if (resourcePath.endsWith("/")) {
            indexOfSlash = resourcePath.lastIndexOf(47, indexOfSlash - 1);
        }
        if (indexOfSlash < 0) {
            return null;
        }
        return new String[]{resourcePath.substring(0, indexOfSlash + 1), resourcePath.substring(indexOfSlash + 1)};
    }

    protected static String getPluginKey(String completeKeyOrPluginKey) {
        return completeKeyOrPluginKey.split(":")[0];
    }
}

