/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.impl;

import com.atlassian.json.marshal.Jsonable;
import com.atlassian.plugin.webresource.bigpipe.BigPipe;
import com.atlassian.plugin.webresource.impl.Globals;
import com.atlassian.plugin.webresource.impl.RequestCache;
import com.atlassian.plugin.webresource.impl.UrlBuildingStrategy;
import com.atlassian.plugin.webresource.impl.snapshot.Snapshot;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class RequestState {
    protected final LinkedHashSet<String> included;
    protected final LinkedHashSet<String> excluded;
    protected final LinkedHashMap<String, Jsonable> includedData;
    protected final Set<String> excludedData;
    protected final RequestCache cache;
    private final UrlBuildingStrategy urlBuildingStrategy;
    private volatile long bigPipDeadline;
    private final BigPipe pipe = new BigPipe();
    protected final Globals globals;

    private RequestState(Globals globals, LinkedHashSet<String> included, LinkedHashSet<String> excluded, LinkedHashMap<String, Jsonable> includedData, Set<String> excludedData, RequestCache cache, UrlBuildingStrategy urlBuildingStrategy) {
        this.globals = globals;
        this.included = included;
        this.excluded = excluded;
        this.includedData = includedData;
        this.excludedData = excludedData;
        this.cache = cache;
        this.urlBuildingStrategy = urlBuildingStrategy;
        this.bigPipDeadline = System.currentTimeMillis() + globals.getConfig().getDefaultBigPipeDeadline().toMillis();
    }

    public RequestState(Globals globals, UrlBuildingStrategy urlBuildingStrategy) {
        this(globals, new LinkedHashSet<String>(), new LinkedHashSet<String>(), new LinkedHashMap<String, Jsonable>(), new HashSet<String>(), new RequestCache(globals), urlBuildingStrategy);
    }

    public UrlBuildingStrategy getUrlStrategy() {
        return this.urlBuildingStrategy;
    }

    public RequestState deepClone() {
        RequestState clone = new RequestState(this.globals, new LinkedHashSet<String>(this.included), new LinkedHashSet<String>(this.excluded), new LinkedHashMap<String, Jsonable>(this.includedData), new HashSet<String>(this.excludedData), this.cache, this.urlBuildingStrategy);
        clone.setBigPipeDeadline(this.bigPipDeadline);
        return clone;
    }

    public void setBigPipeDeadline(long deadline) {
        this.bigPipDeadline = deadline;
    }

    public long getBigPipeDeadline() {
        return this.bigPipDeadline;
    }

    public LinkedHashSet<String> getIncluded() {
        return this.included;
    }

    public LinkedHashMap<String, Jsonable> getIncludedData() {
        return this.includedData;
    }

    public Set<String> getExcludedData() {
        return this.excludedData;
    }

    public LinkedHashSet<String> getExcluded() {
        return this.excluded;
    }

    public BigPipe getBigPipe() {
        return this.pipe;
    }

    public void clearIncludedAndUpdateExcluded(LinkedHashSet<String> excludedResolved) {
        this.included.clear();
        this.excluded.addAll(excludedResolved);
        this.excludedData.addAll(this.includedData.keySet());
        this.includedData.clear();
    }

    public Globals getGlobals() {
        return this.globals;
    }

    public Snapshot getSnapshot() {
        return this.getCache().getSnapshot();
    }

    public RequestCache getCache() {
        return this.cache;
    }

    public String toString() {
        return "[" + StringUtils.join(this.included, (String)", ") + "] - [" + StringUtils.join(this.excluded, (String)", ") + "]";
    }
}

