/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.assembler;

import com.atlassian.plugin.webresource.BatchResourceContentsWebFormatter;
import com.atlassian.plugin.webresource.JavascriptWebResource;
import com.atlassian.plugin.webresource.PrefetchLinkWebResource;
import com.atlassian.plugin.webresource.ResourceUrl;
import com.atlassian.plugin.webresource.WebResourceFormatter;
import com.atlassian.plugin.webresource.assembler.DefaultPluginCssResource;
import com.atlassian.plugin.webresource.assembler.DefaultPluginJsResource;
import com.atlassian.plugin.webresource.assembler.DefaultPluginUrlResource;
import com.atlassian.plugin.webresource.data.DataTagWriter;
import com.atlassian.plugin.webresource.impl.RequestState;
import com.atlassian.plugin.webresource.impl.config.Config;
import com.atlassian.plugin.webresource.impl.support.Support;
import com.atlassian.webresource.api.UrlMode;
import com.atlassian.webresource.api.assembler.WebResource;
import com.atlassian.webresource.api.assembler.WebResourceSet;
import com.atlassian.webresource.api.assembler.resource.PluginUrlResource;
import com.atlassian.webresource.api.data.PluginDataResource;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;

public class DefaultWebResourceSet
implements WebResourceSet {
    private final List<Container> resources;
    private final List<PluginDataResource> data;
    private final boolean complete;
    private final RequestState requestState;
    private final Config config;

    public DefaultWebResourceSet(RequestState requestState, List<PluginDataResource> data, List<ResourceUrl> resourceUrls, boolean complete, Config config) {
        this.requestState = requestState;
        this.data = data;
        this.complete = complete;
        this.config = config;
        this.resources = new LinkedList<Container>();
        for (ResourceUrl resourceUrl : resourceUrls) {
            DefaultPluginUrlResource pluginUrlResource;
            String type = resourceUrl.getType();
            if ("js".equals(type)) {
                pluginUrlResource = new DefaultPluginJsResource(resourceUrl);
            } else if ("css".equals(type)) {
                pluginUrlResource = new DefaultPluginCssResource(resourceUrl);
            } else {
                throw new RuntimeException("unsupported extension " + type);
            }
            this.resources.add(new Container(resourceUrl, pluginUrlResource));
        }
    }

    public Iterable<WebResource> getResources() {
        LinkedList<PluginDataResource> webResources = new LinkedList<PluginDataResource>(this.data);
        for (Container resource : this.resources) {
            webResources.add((PluginDataResource)resource.getPluginUrlResource());
        }
        return webResources;
    }

    public <T extends WebResource> Iterable<T> getResources(Class<T> clazz) {
        return Iterables.filter(this.getResources(), (Predicate)Predicates.instanceOf(clazz));
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void writeHtmlTags(Writer writer, UrlMode urlMode) {
        this.writeHtmlTags(writer, urlMode, (Predicate<WebResource>)Predicates.alwaysTrue());
    }

    public void writeHtmlTags(Writer writer, UrlMode urlMode, Predicate<WebResource> predicate) {
        this.writeHtmlTags(writer, urlMode, predicate, (Predicate<ResourceUrl>)Predicates.alwaysTrue());
    }

    public void writePrefetchLinks(Writer writer, UrlMode urlMode) {
        this.writeFormattedResources(writer, urlMode, (Predicate<Container>)Predicates.alwaysTrue(), Collections.singletonList(PrefetchLinkWebResource.FORMATTER), true);
    }

    public void writeHtmlTags(Writer writer, UrlMode urlMode, Predicate<WebResource> predicate, Predicate<ResourceUrl> legacyPredicate) {
        try {
            new DataTagWriter().write(writer, Iterables.filter(this.data, predicate));
        }
        catch (IOException ex) {
            Support.LOGGER.error("IOException encountered rendering data tags", (Throwable)ex);
        }
        this.writeFormattedResources(writer, urlMode, new ContainerPredicate(predicate, legacyPredicate), WebResourceFormatter.webResourceFormatters, false);
    }

    private void writeFormattedResources(Writer writer, UrlMode urlMode, Predicate<Container> predicate, List<WebResourceFormatter> webResourceFormatters, boolean writingPrefetchLinks) {
        LinkedList<Container> localCopyOfResources = new LinkedList<Container>();
        for (Container resource : this.resources) {
            if (!predicate.apply((Object)resource)) continue;
            localCopyOfResources.add(resource);
        }
        boolean isDeferJsAttributeEnabled = this.config.isDeferJsAttributeEnabled();
        for (WebResourceFormatter formatter : webResourceFormatters) {
            Iterator iter = localCopyOfResources.iterator();
            while (iter.hasNext()) {
                Container resource = (Container)iter.next();
                if (!formatter.matches(resource.getResourceUrl().getName())) continue;
                this.writeResourceTag(urlMode, resource, formatter, writer, isDeferJsAttributeEnabled, writingPrefetchLinks);
                iter.remove();
            }
        }
        for (Container resource : localCopyOfResources) {
            this.writeContentAndSwallowErrors(writer, "<!-- Error loading resource \"", resource.getResourceUrl().getKey(), "\".  No resource formatter matches \"", resource.getResourceUrl().getName(), "\" -->\n");
        }
    }

    private void writeResourceTag(UrlMode urlMode, Container resource, WebResourceFormatter formatter, Writer writer, boolean isDeferJsAttributeEnabled, boolean writingPrefetchLinks) {
        PluginUrlResource urlResource = resource.getPluginUrlResource();
        String formattedResource = formatter instanceof JavascriptWebResource ? ((JavascriptWebResource)formatter).formatResource(urlResource.getStaticUrl(urlMode), urlResource.getParams().all(), isDeferJsAttributeEnabled) : formatter.formatResource(urlResource.getStaticUrl(urlMode), urlResource.getParams().all());
        if (!writingPrefetchLinks && this.requestState.getGlobals().getConfig().isBatchContentTrackingEnabled()) {
            formattedResource = BatchResourceContentsWebFormatter.insertBatchResourceContents(resource, formattedResource);
        }
        this.writeContentAndSwallowErrors(writer, formattedResource);
    }

    private void writeContentAndSwallowErrors(Writer writer, String ... contents) {
        try {
            for (String content : contents) {
                writer.write(content);
            }
        }
        catch (IOException ex) {
            Support.LOGGER.error("IOException encountered rendering resource", (Throwable)ex);
        }
    }

    public static class Container {
        private final ResourceUrl resourceUrl;
        private final PluginUrlResource pluginUrlResource;

        public Container(ResourceUrl resourceUrl, PluginUrlResource pluginUrlResource) {
            this.resourceUrl = resourceUrl;
            this.pluginUrlResource = pluginUrlResource;
        }

        public PluginUrlResource getPluginUrlResource() {
            return this.pluginUrlResource;
        }

        public ResourceUrl getResourceUrl() {
            return this.resourceUrl;
        }
    }

    private static class ContainerPredicate
    implements Predicate<Container> {
        private final Predicate<WebResource> resourcePredicate;
        private final Predicate<ResourceUrl> legacyPredicate;

        public ContainerPredicate(Predicate<WebResource> resourcePredicate, Predicate<ResourceUrl> legacyPredicate) {
            this.resourcePredicate = resourcePredicate;
            this.legacyPredicate = legacyPredicate;
        }

        public boolean apply(@Nullable Container container) {
            return container != null && this.resourcePredicate.apply((Object)container.getPluginUrlResource()) && this.legacyPredicate.apply((Object)container.getResourceUrl());
        }
    }
}

