/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.url;

import com.atlassian.plugin.webresource.Globals;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import com.atlassian.plugin.webresource.condition.ConditionState;
import com.atlassian.plugin.webresource.condition.ConditionsCache;
import com.atlassian.plugin.webresource.transformer.StaticTransformers;
import com.atlassian.plugin.webresource.transformer.TransformerCache;
import com.atlassian.plugin.webresource.url.DefaultUrlBuilder;
import com.atlassian.plugin.webresource.url.UrlParameters;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUrlBuilderMap {
    private static final Logger log = LoggerFactory.getLogger(DefaultUrlBuilderMap.class);
    private final Iterable<WebResourceModuleDescriptor> wrmds;
    private final StaticTransformers staticTransformers;
    private final Map<String, UrlParameters> urlBuildersByType;
    private final TransformerCache transformerCache;

    public DefaultUrlBuilderMap(WebResourceModuleDescriptor wrmd, TransformerCache transformerCache, StaticTransformers staticTransformers) {
        this.staticTransformers = staticTransformers;
        this.wrmds = ImmutableList.of((Object)((Object)wrmd));
        this.transformerCache = transformerCache;
        this.urlBuildersByType = Maps.newHashMap();
    }

    public DefaultUrlBuilderMap(Iterable<WebResourceModuleDescriptor> wrmds, TransformerCache transformerCache, StaticTransformers staticTransformers) {
        this.staticTransformers = staticTransformers;
        this.wrmds = Lists.newArrayList(wrmds);
        this.transformerCache = transformerCache;
        this.urlBuildersByType = Maps.newHashMap();
    }

    public UrlParameters getOrCreateForType(String type, ConditionState conditionsRun, ConditionsCache conditionsCache, Globals globals) {
        UrlParameters urlParams = this.urlBuildersByType.get(type);
        if (null == urlParams) {
            DefaultUrlBuilder urlBuilder = new DefaultUrlBuilder();
            for (WebResourceModuleDescriptor wrmd : this.wrmds) {
                try {
                    wrmd.addToUrl(type, this.staticTransformers, this.transformerCache, urlBuilder, conditionsRun, conditionsCache);
                }
                catch (RuntimeException e) {
                    boolean hasWebResourceInGlobals = globals.getBundles().get(wrmd.getCompleteKey()) != null;
                    boolean hasWebResourceInPluginSystem = globals.getConfig().getIntegration().getPluginAccessor().getEnabledPluginModule(wrmd.getCompleteKey()) != null;
                    log.error("can't get transformer parameters for \"" + wrmd.getCompleteKey() + "\" (" + "it " + (hasWebResourceInGlobals ? "exists in globals" : "doesn't exists in globals") + ", it " + (hasWebResourceInPluginSystem ? "exists in plugin system" : "doesn't exists in plugin system") + ")", (Throwable)e);
                }
            }
            urlParams = urlBuilder.build();
            this.urlBuildersByType.put(type, urlParams);
        }
        return urlParams;
    }
}

