/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.webresource.AbstractPluginResource;
import com.atlassian.plugin.webresource.BatchedWebResourceDescriptor;
import com.atlassian.plugin.webresource.Globals;
import com.atlassian.plugin.webresource.ResourceUtils;
import com.atlassian.plugin.webresource.url.UrlParameters;
import com.atlassian.util.concurrent.LazyReference;
import java.util.Collections;
import java.util.Map;

public class SinglePluginResource
extends AbstractPluginResource {
    private final String resourceName;
    private final String moduleCompleteKey;
    private final boolean cached;
    private final LazyReference<String> type;

    public SinglePluginResource(Globals globals, String resourceName, String moduleCompleteKey, boolean cached, boolean isCdnSupported) {
        this(globals, resourceName, moduleCompleteKey, cached, UrlParameters.of(isCdnSupported), Collections.emptyMap());
    }

    public SinglePluginResource(Globals globals, final String resourceName, String moduleCompleteKey, boolean cached, UrlParameters urlParams, Map<String, String> params) {
        super(globals, urlParams, params, Collections.<BatchedWebResourceDescriptor>emptySet());
        this.resourceName = resourceName;
        this.moduleCompleteKey = moduleCompleteKey;
        this.cached = cached;
        this.type = new LazyReference<String>(){

            protected String create() throws Exception {
                return ResourceUtils.getType(resourceName);
            }
        };
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    @Override
    public String getCompleteKey() {
        return this.moduleCompleteKey;
    }

    @Override
    public String getVersion() {
        Plugin plugin = this.globals.getConfig().getIntegration().getPluginAccessor().getEnabledPluginModule(this.getCompleteKey()).getPlugin();
        return plugin.getPluginInformation().getVersion();
    }

    @Override
    public String getUrl(boolean isAbsolute) {
        return this.globals.getRouter().cloneWithNewUrlMode(isAbsolute).urlFor(this);
    }

    @Override
    public boolean isCacheSupported() {
        return this.cached;
    }

    @Override
    public String getType() {
        return (String)this.type.get();
    }

    @Override
    public Map<String, String> getParamsWithBatchableParams() {
        return this.urlParams.toQueryString();
    }
}

