package com.atlassian.plugin.webresource;

import com.atlassian.plugin.util.PluginUtils;

import java.util.Collections;
import java.util.List;

/**
 * Default configuration for the plugin resource locator, for those applications that do not want to perform
 * any super-batching.
 */
public class DefaultResourceBatchingConfiguration implements ResourceBatchingConfiguration
{
    public static final String PLUGIN_WEBRESOURCE_BATCHING_OFF = "plugin.webresource.batching.off";
    public static final String PLUGIN_WEB_RESOURCE_BATCH_CONTENT_TRACKING = "plugin.webresource.batch.content.tracking";
    public static final String PLUGIN_WEB_RESOURCE_JAVASCRIPT_TRY_CATCH_WRAPPING = "plugin.webresource.javascript.try.catch.wrapping";
    public static final String PLUGIN_WEB_RESOURCE_SOURCE_MAP_ENABLED = "plugin.webresource.source.map.enabled";

    public boolean isSuperBatchingEnabled()
    {
        return false;
    }

    public List<String> getSuperBatchModuleCompleteKeys()
    {
        return Collections.emptyList();
    }

    public boolean isContextBatchingEnabled()
    {
        return false;
    }

    public boolean isPluginWebResourceBatchingEnabled()
    {
        final String explicitSetting = System.getProperty(PLUGIN_WEBRESOURCE_BATCHING_OFF);
        if (explicitSetting != null)
        {
            return !Boolean.parseBoolean(explicitSetting);
        }
        else
        {
            return !Boolean.parseBoolean(System.getProperty(PluginUtils.ATLASSIAN_DEV_MODE));
        }
    }

    /**
     * Currently (as of v2.14) this is false by default. It is likely to become true by
     * default in the future.
     */
    public boolean isJavaScriptTryCatchWrappingEnabled()
    {
        final String javaScriptTryCatchWrapping = System.getProperty(PLUGIN_WEB_RESOURCE_JAVASCRIPT_TRY_CATCH_WRAPPING);
        return javaScriptTryCatchWrapping != null && Boolean.parseBoolean(javaScriptTryCatchWrapping);
    }

    @Override
    public boolean isBatchContentTrackingEnabled()
    {
        final String trackingSetting = System.getProperty(PLUGIN_WEB_RESOURCE_BATCH_CONTENT_TRACKING);
        return trackingSetting != null && Boolean.parseBoolean(trackingSetting);
    }

    @Override
    public boolean resplitMergedContextBatchesForThisRequest() {
        return false;
    }

    @Override
    public boolean isSourceMapEnabled()
    {
        return Boolean.parseBoolean(System.getProperty(PLUGIN_WEB_RESOURCE_SOURCE_MAP_ENABLED));
    }
}
