/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.webresource.PluginResource;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

class BatchResourceComparator
implements Comparator<PluginResource> {
    private final List<String> CONDITONAL_PARAMS = ImmutableList.of((Object)"cache", (Object)"media", (Object)"conditionalComment", (Object)"ieonly");
    private final Set<String> CONDITONAL_PARAMS_SET = ImmutableSet.copyOf(this.CONDITONAL_PARAMS);

    BatchResourceComparator() {
    }

    @Override
    public int compare(PluginResource resource1, PluginResource resource2) {
        Sets.SetView resource1Conditions = Sets.intersection(resource1.getParams().keySet(), this.CONDITONAL_PARAMS_SET);
        Sets.SetView resource2Conditions = Sets.intersection(resource2.getParams().keySet(), this.CONDITONAL_PARAMS_SET);
        if (resource1Conditions.size() == 1 && resource2Conditions.size() == 1) {
            int conditionIndexOfResource2;
            String conditionOfResource1 = (String)Iterables.getOnlyElement((Iterable)resource1Conditions);
            String conditionOfResource2 = (String)Iterables.getOnlyElement((Iterable)resource2Conditions);
            int conditionIndexOfResource1 = this.CONDITONAL_PARAMS.indexOf(conditionOfResource1);
            if (conditionIndexOfResource1 != (conditionIndexOfResource2 = this.CONDITONAL_PARAMS.indexOf(conditionOfResource2))) {
                return this.CONDITONAL_PARAMS.indexOf(conditionOfResource1) - this.CONDITONAL_PARAMS.indexOf(conditionOfResource2);
            }
        }
        if (resource1Conditions.size() == resource2Conditions.size()) {
            return resource1.getUrl().compareTo(resource2.getUrl());
        }
        return resource1Conditions.size() - resource2Conditions.size();
    }
}

