/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.assembler;

import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.assembler.LegacyPageBuilderService;
import com.atlassian.webresource.api.assembler.WebResourceAssembler;
import com.atlassian.webresource.api.assembler.WebResourceAssemblerFactory;
import java.util.Map;

public class DefaultPageBuilderService
implements LegacyPageBuilderService {
    private static final String REQUEST_CACHE_REQUIRED_RESOURCES = "plugin.webresource.required.resources";
    private final WebResourceIntegration webResourceIntegration;
    private final WebResourceAssemblerFactory webResourceAssemblerFactory;

    public DefaultPageBuilderService(WebResourceIntegration webResourceIntegration, WebResourceAssemblerFactory webResourceAssemblerFactory) {
        this.webResourceIntegration = webResourceIntegration;
        this.webResourceAssemblerFactory = webResourceAssemblerFactory;
    }

    public WebResourceAssembler assembler() {
        return this.cachedAssembler();
    }

    private WebResourceAssembler cachedAssembler() {
        Map<String, Object> cache = this.webResourceIntegration.getRequestCache();
        WebResourceAssembler assembler = (WebResourceAssembler)cache.get(REQUEST_CACHE_REQUIRED_RESOURCES);
        if (assembler == null) {
            assembler = this.webResourceAssemblerFactory.create().build();
            cache.put(REQUEST_CACHE_REQUIRED_RESOURCES, assembler);
        }
        return assembler;
    }

    @Override
    public void clearRequestLocal() {
        this.webResourceIntegration.getRequestCache().remove(REQUEST_CACHE_REQUIRED_RESOURCES);
    }
}

