/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.cache.filecache.impl;

import com.atlassian.plugin.cache.filecache.FileCacheStreamProvider;
import com.atlassian.plugin.servlet.DownloadException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedFile {
    private static final Logger log = LoggerFactory.getLogger(CachedFile.class);
    private final File tmpFile;
    private final FileOpener fileOpener;
    private final Object lock = new Object();
    private int concurrentCount;
    private State state = State.UNCACHED;

    public CachedFile(File tmpFile) {
        this(tmpFile, new FileInputStreamOpener());
    }

    CachedFile(File tmpFile, FileOpener fileOpener) {
        this.tmpFile = tmpFile;
        this.fileOpener = fileOpener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stream(OutputStream dest, FileCacheStreamProvider input) throws DownloadException {
        boolean fromCache = this.doEnter(input);
        try {
            if (fromCache) {
                this.streamFromCache(dest);
            } else {
                input.writeStream(dest);
            }
        }
        finally {
            this.doExit();
        }
    }

    State getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doEnter(FileCacheStreamProvider input) {
        Object object = this.lock;
        synchronized (object) {
            boolean useCache = false;
            if (this.state == State.UNCACHED) {
                try {
                    this.streamToCache(input);
                    this.state = State.CACHED;
                    useCache = true;
                }
                catch (Exception e) {
                    log.warn("Problem caching to disk, skipping cache for this entry", (Throwable)e);
                    this.state = State.DELETED;
                }
            } else if (this.state == State.CACHED) {
                useCache = true;
            } else if (this.state == State.NEEDSDELETE) {
                useCache = true;
            }
            ++this.concurrentCount;
            return useCache && this.tmpFile.isFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExit() {
        Object object = this.lock;
        synchronized (object) {
            --this.concurrentCount;
            if (this.state == State.NEEDSDELETE && this.concurrentCount == 0) {
                this.tmpFile.delete();
                this.state = State.DELETED;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteWhenPossible() {
        Object object = this.lock;
        synchronized (object) {
            if (this.state == State.UNCACHED) {
                this.state = State.DELETED;
            } else if (this.state == State.CACHED) {
                this.state = State.NEEDSDELETE;
            }
            if (this.state == State.NEEDSDELETE && this.concurrentCount == 0) {
                this.tmpFile.delete();
                this.state = State.DELETED;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void streamToCache(FileCacheStreamProvider input) throws IOException, DownloadException {
        OutputStream cacheout = null;
        try {
            cacheout = new BufferedOutputStream(this.fileOpener.open(this.tmpFile));
            input.writeStream(cacheout);
        }
        finally {
            if (cacheout != null) {
                cacheout.close();
            }
        }
    }

    private void streamFromCache(OutputStream out) throws DownloadException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(this.tmpFile);
            IOUtils.copyLarge((InputStream)in, (OutputStream)out);
            out.flush();
        }
        catch (IOException e) {
            try {
                throw new DownloadException((Exception)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
    }

    static class FileInputStreamOpener
    implements FileOpener {
        FileInputStreamOpener() {
        }

        @Override
        public OutputStream open(File file) throws IOException {
            return new FileOutputStream(file);
        }
    }

    static interface FileOpener {
        public OutputStream open(File var1) throws IOException;
    }

    static enum State {
        UNCACHED,
        CACHED,
        NEEDSDELETE,
        DELETED;

    }
}

