/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.servlet.DownloadableClasspathResource;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.servlet.DownloadableWebResource;
import com.atlassian.plugin.servlet.EmptyDownloadableResource;
import com.atlassian.plugin.servlet.ForwardableResource;
import com.atlassian.plugin.servlet.ServletContextFactory;
import com.atlassian.plugin.webresource.DownloadableResourceBuilder;
import com.atlassian.plugin.webresource.DownloadableResourceFinder;
import com.atlassian.plugin.webresource.QueryParams;
import com.atlassian.plugin.webresource.SinglePluginResource;
import com.atlassian.plugin.webresource.UrlParseException;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import com.atlassian.plugin.webresource.WebResourceTransformation;
import com.atlassian.plugin.webresource.url.CDNSupport;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleDownloadableResourceBuilder
implements DownloadableResourceBuilder,
DownloadableResourceFinder {
    private static final String DOWNLOAD_TYPE = "download";
    private static final Logger log = LoggerFactory.getLogger(SingleDownloadableResourceBuilder.class);
    private final PluginAccessor pluginAccessor;
    private final ServletContextFactory servletContextFactory;

    public SingleDownloadableResourceBuilder(PluginAccessor pluginAccessor, ServletContextFactory servletContextFactory) {
        this.pluginAccessor = pluginAccessor;
        this.servletContextFactory = servletContextFactory;
    }

    @Override
    public boolean matches(String path) {
        return path.indexOf("/download/resources") != -1;
    }

    @Override
    public DownloadableResource parse(String path, Map<String, String> params) throws UrlParseException {
        String[] parts;
        int indexOfPrefix = path.indexOf("/download/resources");
        String libraryAndResource = path.substring(indexOfPrefix + "/download/resources".length() + 1);
        if (libraryAndResource.indexOf(63) != -1) {
            libraryAndResource = libraryAndResource.substring(0, libraryAndResource.indexOf(63));
        }
        if ((parts = libraryAndResource.split("/", 2)).length != 2) {
            throw new UrlParseException("Could not parse invalid plugin resource url: " + path);
        }
        SinglePluginResource resource = new SinglePluginResource(parts[1], parts[0], path.substring(0, indexOfPrefix).length() > 0, CDNSupport.OK);
        return this.find(resource.getModuleCompleteKey(), resource.getResourceName(), params);
    }

    @Override
    public DownloadableResource find(String moduleKey, String resourceName, Map<String, String> params) {
        return this.locatePluginResource(moduleKey, resourceName, QueryParams.of(params));
    }

    /*
     * Enabled aggressive block sorting
     */
    private DownloadableResource locatePluginResource(String moduleCompleteKey, String resourceName, QueryParams params) {
        DownloadableResource resource;
        if (moduleCompleteKey.indexOf(":") > -1) {
            ModuleDescriptor moduleDescriptor = this.pluginAccessor.getEnabledPluginModule(moduleCompleteKey);
            if (moduleDescriptor == null) {
                log.debug("Module not found: {}", (Object)moduleCompleteKey);
                return null;
            }
            resource = this.getResourceFromModule(moduleDescriptor, resourceName, "", params);
        } else {
            resource = this.getResourceFromPlugin(this.pluginAccessor.getPlugin(moduleCompleteKey), resourceName, "", params);
        }
        if (resource == null) {
            resource = this.getResourceFromPlugin(this.getPlugin(moduleCompleteKey), resourceName, "", params);
        }
        if (resource == null) {
            log.info("Unable to find resource for plugin: {} and path: {}", (Object)moduleCompleteKey, (Object)resourceName);
            return null;
        }
        return resource;
    }

    private Plugin getPlugin(String moduleKey) {
        int semicolonIndex = moduleKey.indexOf(58);
        if (semicolonIndex < 0 || semicolonIndex == moduleKey.length() - 1) {
            return null;
        }
        return this.pluginAccessor.getPlugin(moduleKey.substring(0, semicolonIndex));
    }

    private DownloadableResource getResourceFromModule(ModuleDescriptor<?> moduleDescriptor, String resourcePath, String filePath, QueryParams params) {
        Plugin plugin = this.pluginAccessor.getPlugin(moduleDescriptor.getPluginKey());
        ResourceLocation resourceLocation = moduleDescriptor.getResourceLocation(DOWNLOAD_TYPE, resourcePath);
        if (resourceLocation != null) {
            boolean disableMinification = false;
            if (moduleDescriptor instanceof WebResourceModuleDescriptor) {
                disableMinification = ((WebResourceModuleDescriptor)moduleDescriptor).isDisableMinification();
            }
            return this.getDownloadablePluginResource(plugin, resourceLocation, moduleDescriptor, filePath, disableMinification, params);
        }
        String[] nextParts = this.splitLastPathPart(resourcePath);
        if (nextParts == null) {
            return null;
        }
        return this.getResourceFromModule(moduleDescriptor, nextParts[0], nextParts[1] + filePath, params);
    }

    private DownloadableResource getResourceFromPlugin(Plugin plugin, String resourcePath, String filePath, QueryParams params) {
        if (plugin == null) {
            return null;
        }
        ResourceLocation resourceLocation = plugin.getResourceLocation(DOWNLOAD_TYPE, resourcePath);
        if (resourceLocation != null) {
            return this.getDownloadablePluginResource(plugin, resourceLocation, null, filePath, false, params);
        }
        String[] nextParts = this.splitLastPathPart(resourcePath);
        if (nextParts == null) {
            return null;
        }
        return this.getResourceFromPlugin(plugin, nextParts[0], nextParts[1] + filePath, params);
    }

    private DownloadableResource getDownloadablePluginResource(Plugin plugin, ResourceLocation originalResourceLocation, ModuleDescriptor<?> descriptor, String filePath, boolean disableMinification, QueryParams params) {
        ResourceLocation resourceLocation = this.substituteVariables(originalResourceLocation);
        String sourceParam = resourceLocation.getParameter("source");
        if ("webContext".equalsIgnoreCase(sourceParam)) {
            return new ForwardableResource(resourceLocation);
        }
        Object actualResource = "webContextStatic".equalsIgnoreCase(sourceParam) ? new DownloadableWebResource(plugin, resourceLocation, filePath, this.servletContextFactory.getServletContext(), disableMinification) : new DownloadableClasspathResource(plugin, resourceLocation, filePath);
        DownloadableClasspathResource result = actualResource;
        if (descriptor instanceof WebResourceModuleDescriptor) {
            DownloadableClasspathResource lastResource = actualResource;
            WebResourceModuleDescriptor desc = (WebResourceModuleDescriptor)descriptor;
            if (desc.shouldDisplay(params)) {
                for (WebResourceTransformation list : desc.getTransformations()) {
                    if (!list.matches(resourceLocation)) continue;
                    lastResource = list.transformDownloadableResource(this.pluginAccessor, desc, (DownloadableResource)actualResource, resourceLocation, filePath, params);
                }
                result = lastResource;
            } else {
                result = new EmptyDownloadableResource(plugin, resourceLocation);
            }
        }
        return result;
    }

    private ResourceLocation substituteVariables(ResourceLocation in) {
        String location = in.getLocation();
        if (!location.contains("$")) {
            return in;
        }
        return new ResourceLocation(location, in.getName(), in.getType(), in.getContentType(), in.getContent(), in.getParams());
    }

    String[] splitLastPathPart(String resourcePath) {
        int indexOfSlash = resourcePath.lastIndexOf(47);
        if (resourcePath.endsWith("/")) {
            indexOfSlash = resourcePath.lastIndexOf(47, indexOfSlash - 1);
        }
        if (indexOfSlash < 0) {
            return null;
        }
        return new String[]{resourcePath.substring(0, indexOfSlash + 1), resourcePath.substring(indexOfSlash + 1)};
    }
}

