/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.webresource.ResourceContentAnnotator;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TryCatchJsResourceContentAnnotator
implements ResourceContentAnnotator {
    private static final byte[] BEFORE_CHUNK = "try {\n".getBytes();
    private static final byte[] AFTER_CHUNK = "\n} catch (err) {\n    if (console && console.log && console.error) {\n        console.log(\"Error running batched script.\");\n        console.error(err);\n    }\n}\n\n".getBytes();
    private static final Logger log = LoggerFactory.getLogger(TryCatchJsResourceContentAnnotator.class);

    TryCatchJsResourceContentAnnotator() {
    }

    @Override
    public void before(OutputStream stream) throws IOException {
        log.debug("Writing try-catch annotation (before)");
        stream.write(BEFORE_CHUNK);
    }

    @Override
    public void after(OutputStream stream) throws IOException {
        log.debug("Writing try-catch annotation (after)");
        stream.write(AFTER_CHUNK);
    }
}

