package com.atlassian.plugin.webresource;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.servlet.DownloadableResource;

/**
 * * @since 3.0
 */
public class SourceDescribingTransformResource extends AbstractTransformResource
{
    static boolean matches(final ResourceDescriptor resource)
    {
        return CssWebResource.FORMATTER.matches(resource.getName()) || JavascriptWebResource.FORMATTER.matches(resource.getName());
    }

    private final ModuleDescriptor<?> moduleDescriptor;
    private final ResourceDescriptor resourceDescriptor;

    SourceDescribingTransformResource(final ModuleDescriptor<?> moduleDescriptor,
                                      final DownloadableResource originalResource,
                                      final ResourceDescriptor resourceDescriptor)
    {
        super(originalResource);
        this.moduleDescriptor = moduleDescriptor;
        this.resourceDescriptor = resourceDescriptor;
    }

    CharSequence transform(final CharSequence originalContent)
    {
        String sourceDescriptor = String.format("/* module-key = '%s', location = '%s' */\n", moduleDescriptor.getCompleteKey(), resourceDescriptor.getLocation());
        return sourceDescriptor + originalContent;
    }

    @Override
    public String toString()
    {
        return "Source Describing Transform Resource: originalResource: " + originalResource.toString();
    }
}