package com.atlassian.plugin.webresource;

import java.io.IOException;
import java.io.OutputStream;

/**
 * If a minified files follows another file and the former does not have a free floating carriage return AND ends in
 * a // comment then the one line minified file will in fact be lost from view in a batched send.  So we need
 * to put a new line between files
 * <p/>
 * This is a stateless implementation of the {@link ResourceContentAnnotator} that will write a newline after each resource.
 */
class NewlineResourceContentAnnotator implements ResourceContentAnnotator
{
    @Override
    public void before(OutputStream stream) throws IOException
    {
        // Nothing doing
    }

    @Override
    public void after(OutputStream stream) throws IOException
    {
        stream.write('\n');
    }
}
