package com.atlassian.plugin.webresource.url;

import com.atlassian.annotations.ExperimentalApi;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Interface for resource mutators (eg transforms) to contribute information to a resource URL
 *
 * @since v3.0
 */
@ExperimentalApi
public interface UrlBuilder
{
    /**
     * Contributes to the url's static hash
     * @param name name of the hash. This is used for logging and debugging only.
     * @param value value to contribute to the hash. The value will be converted to a String using value.toString()
     * when hashing.
     */
    void addToHash(String name, Object value);

    /**
     * Contributes to the url's querystring
     * @param key query key
     * @param value query value
     */
    void addToQueryString(String key, String value);
}
