package com.atlassian.plugin.webresource.transformer;

import org.dom4j.Element;

/**
 * Factory to create URL aware web resource transformers
 * @since v3.0
 */
public interface WebResourceTransformerFactory
{
    /**
     * Return the URL builder for this transform
     * @param element transformer config
     * @return an builder that contributes parameters to the URL
     */
    TransformerUrlBuilder makeUrlBuilder(Element element);

    /**
     * Return the transformer for this transform
     * @param element transformer config
     * @return a transformer that reads values from the url and transforms a webresource
     */
    UrlReadingWebResourceTransformer makeResourceTransformer(Element element);
}
