package com.atlassian.plugin.webresource;

import com.atlassian.plugin.webresource.url.NamedHash;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Operations on super batches
 * @since v3.0
 */
class SuperBatchOperations
{
    /**
     * Merges a plugin resource with a super batch. Assumes that the superbatch and plugin have the same params
     * @param superBatch super batch
     * @param pluginResource plugin resource to merge
     * @return merged superbatch resource
     */
    public static SuperBatchPluginResource mergeSameBatch(final SuperBatchPluginResource superBatch, final PluginResource pluginResource)
    {
        Map<String, String> mergedBatchableParams = Maps.newHashMap(superBatch.getBatchableParams());
        mergedBatchableParams.putAll(pluginResource.getBatchableParams());
        List<NamedHash> mergedHashes = ImmutableList.copyOf(Iterables.concat(superBatch.getHashes(), pluginResource.getHashes()));
        SuperBatchPluginResource merged = new SuperBatchPluginResource(superBatch.getType(), mergedHashes, superBatch.getParams(), mergedBatchableParams);
        for (BatchedWebResourceDescriptor bwrd : superBatch.getBatchedWebResourceDescriptors())
        {
            merged.addBatchedWebResourceDescriptor(bwrd);
        }
        for (BatchedWebResourceDescriptor bwrd : pluginResource.getBatchedWebResourceDescriptors())
        {
            merged.addBatchedWebResourceDescriptor(bwrd);
        }
        return merged;
    }
}
