package com.atlassian.plugin.webresource;

import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.cache.CacheHandle;

import java.util.Map;

/**
 * Creates a batch of all like-typed resources that are declared as "super-batch="true"" in their plugin
 * definitions.
 *
 * The URL for batch resources is /download/superbatch/&lt;type>/batch.&lt;type. The additional type part in the path
 * is simply there to make the number of path-parts identical with other resources, so relative URLs will still work
 * in CSS files.
 *
 */
public class SuperBatchDownloadableResource extends AbstractBatchDownloadableResource
{
    public SuperBatchDownloadableResource(final String type, final Map<String, String> params,
                                          final Iterable<DownloadableResource> resources, final CacheHandle cacher,
                                          final ResourceBatchingConfiguration resourceBatchingConfiguration)
    {
        super(type, params, resources, cacher, resourceBatchingConfiguration);
    }

    @Override
    public String toString()
    {
        return "[Superbatch  type=" + getType() + ", params=" + getParams() + "]";
    }
}
