package com.atlassian.plugin.cache.filecache;

import com.atlassian.plugin.servlet.DownloadException;

import java.io.OutputStream;

/**
 * Represents a file cache.
 * @since 2.13
 * @param <K> Key of the cache, should conform the requirements for keys of {@link java.util.Map}.
 */
public interface FileCache<K> {

    /**
     * Stream the contents identified by the key to the destination stream. Should the contents not exist in the cache
     * a new entry should be created if the implementation is a caching implementation.
     * @param key can not be null
     * @param dest where to write the cached item to
     * @param input provides the underlying item on a cache-miss
     * @throws DownloadException if there was an error writing to dest, or reading from input, or reading from the cache
     */
    void stream(K key, OutputStream dest, FileCacheStreamProvider input) throws DownloadException;

    /**
     * Remove all entries in the cache.
     */
    void clear();
}
