/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.transformer;

import com.atlassian.plugin.servlet.DownloadException;
import com.atlassian.plugin.servlet.DownloadableResource;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractTransformedDownloadableResource
implements DownloadableResource {
    private final DownloadableResource originalResource;

    public AbstractTransformedDownloadableResource(DownloadableResource originalResource) {
        this.originalResource = originalResource;
    }

    public boolean isResourceModified(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this.originalResource.isResourceModified(httpServletRequest, httpServletResponse);
    }

    public void serveResource(HttpServletRequest httpServletRequest, HttpServletResponse response) throws DownloadException {
        ServletOutputStream out;
        String contentType = this.getContentType();
        if (StringUtils.isNotBlank((String)contentType)) {
            response.setContentType(contentType);
        }
        try {
            out = response.getOutputStream();
        }
        catch (IOException e) {
            throw new DownloadException((Exception)e);
        }
        this.streamResource((OutputStream)out);
    }

    public String getContentType() {
        return this.originalResource.getContentType();
    }

    protected DownloadableResource getOriginalResource() {
        return this.originalResource;
    }

    public String toString() {
        return "Transformed Downloadable Resource: " + this.originalResource.toString();
    }
}

