/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.cache.filecache.impl;

import com.atlassian.plugin.cache.filecache.FileCache;
import com.atlassian.plugin.cache.filecache.FileCacheStreamProvider;
import com.atlassian.plugin.cache.filecache.impl.CachedFile;
import com.atlassian.plugin.servlet.DownloadException;
import com.google.common.base.Function;
import com.google.common.collect.MapEvictionListener;
import com.google.common.collect.MapMaker;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class FileCacheImpl<K>
implements FileCache<K> {
    static final String EXT = ".cachedfile";
    private final ConcurrentMap<K, CachedFile> cache;
    private final File tmpDir;
    private final AtomicLong filenameCounter;

    public FileCacheImpl(File tmpDir, int maxSize, AtomicLong filenameCounter) throws IOException {
        if (maxSize < 0) {
            throw new IllegalArgumentException("Max files can not be less than zero");
        }
        FileCacheImpl.initDirectory(tmpDir);
        this.tmpDir = tmpDir;
        this.cache = new MapMaker().maximumSize(maxSize).evictionListener(new MapEvictionListener<K, CachedFile>(){

            public void onEviction(K key, CachedFile value) {
                FileCacheImpl.this.onEviction(value);
            }
        }).makeComputingMap(new Function<K, CachedFile>(){

            public CachedFile apply(K key) {
                return FileCacheImpl.this.newCachedFile();
            }
        });
        this.filenameCounter = filenameCounter;
    }

    private static void initDirectory(File tmpDir) throws IOException {
        tmpDir.mkdirs();
        File[] files = tmpDir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (!f.getName().toLowerCase().endsWith(EXT) || f.delete()) continue;
                throw new IOException("Could not delete existing cache file " + f);
            }
        }
        if (!tmpDir.isDirectory()) {
            throw new IOException("Could not create tmp directory " + tmpDir);
        }
    }

    @Override
    public void stream(K key, OutputStream dest, FileCacheStreamProvider input) throws DownloadException {
        CachedFile cachedFile = (CachedFile)this.cache.get(key);
        cachedFile.stream(dest, input);
    }

    @Override
    public void clear() {
        ArrayList cachedFiles = new ArrayList(this.cache.values());
        this.cache.clear();
        for (CachedFile cachedFile : cachedFiles) {
            cachedFile.deleteWhenPossible();
        }
    }

    private CachedFile newCachedFile() {
        File file = new File(this.tmpDir, this.filenameCounter.incrementAndGet() + EXT);
        return new CachedFile(file);
    }

    private void onEviction(CachedFile node) {
        node.deleteWhenPossible();
    }
}

