/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.servlet.ServletContextFactory;
import com.atlassian.plugin.webresource.AbstractBatchResourceBuilder;
import com.atlassian.plugin.webresource.BatchPluginResource;
import com.atlassian.plugin.webresource.ContextBatchDownloadableResourceBuilder;
import com.atlassian.plugin.webresource.ContextBatchSubResourceBuilder;
import com.atlassian.plugin.webresource.DefaultResourceBatchingConfiguration;
import com.atlassian.plugin.webresource.DefaultResourceDependencyResolver;
import com.atlassian.plugin.webresource.DownloadableResourceBuilder;
import com.atlassian.plugin.webresource.PluginResource;
import com.atlassian.plugin.webresource.PluginResourceLocator;
import com.atlassian.plugin.webresource.ResourceBatchingConfiguration;
import com.atlassian.plugin.webresource.ResourceDependencyResolver;
import com.atlassian.plugin.webresource.SingleBatchDownloadableResourceBuilder;
import com.atlassian.plugin.webresource.SingleDownloadableResourceBuilder;
import com.atlassian.plugin.webresource.SinglePluginResource;
import com.atlassian.plugin.webresource.SuperBatchDownloadableResourceBuilder;
import com.atlassian.plugin.webresource.SuperBatchSubResourceBuilder;
import com.atlassian.plugin.webresource.UrlParseException;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginResourceLocatorImpl
implements PluginResourceLocator {
    private static final Logger log = LoggerFactory.getLogger(PluginResourceLocatorImpl.class);
    private final PluginAccessor pluginAccessor;
    private final WebResourceUrlProvider webResourceUrlProvider;
    private final ResourceBatchingConfiguration batchingConfiguration;
    private final List<DownloadableResourceBuilder> builders;
    static final String RESOURCE_SOURCE_PARAM = "source";
    static final String RESOURCE_BATCH_PARAM = "batch";

    public PluginResourceLocatorImpl(WebResourceIntegration webResourceIntegration, ServletContextFactory servletContextFactory, WebResourceUrlProvider webResourceUrlProvider) {
        this(webResourceIntegration, servletContextFactory, webResourceUrlProvider, new DefaultResourceBatchingConfiguration());
    }

    public PluginResourceLocatorImpl(WebResourceIntegration webResourceIntegration, ServletContextFactory servletContextFactory, WebResourceUrlProvider webResourceUrlProvider, ResourceBatchingConfiguration batchingConfiguration) {
        this(webResourceIntegration, servletContextFactory, webResourceUrlProvider, new DefaultResourceDependencyResolver(webResourceIntegration, batchingConfiguration), batchingConfiguration);
    }

    private PluginResourceLocatorImpl(WebResourceIntegration webResourceIntegration, ServletContextFactory servletContextFactory, WebResourceUrlProvider webResourceUrlProvider, ResourceDependencyResolver dependencyResolver, ResourceBatchingConfiguration batchingConfiguration) {
        this.pluginAccessor = webResourceIntegration.getPluginAccessor();
        this.webResourceUrlProvider = webResourceUrlProvider;
        this.batchingConfiguration = batchingConfiguration;
        SingleDownloadableResourceBuilder singlePluginBuilder = new SingleDownloadableResourceBuilder(this.pluginAccessor, servletContextFactory);
        this.builders = Collections.unmodifiableList(Arrays.asList(new SuperBatchDownloadableResourceBuilder(dependencyResolver, this.pluginAccessor, webResourceUrlProvider, singlePluginBuilder), new SuperBatchSubResourceBuilder(dependencyResolver, singlePluginBuilder), new ContextBatchDownloadableResourceBuilder(dependencyResolver, this.pluginAccessor, webResourceUrlProvider, singlePluginBuilder), new ContextBatchSubResourceBuilder(dependencyResolver, singlePluginBuilder), new SingleBatchDownloadableResourceBuilder(this.pluginAccessor, webResourceUrlProvider, singlePluginBuilder), singlePluginBuilder));
    }

    @Override
    public boolean matches(String url) {
        for (DownloadableResourceBuilder builder : this.builders) {
            if (!builder.matches(url)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DownloadableResource getDownloadableResource(String url, Map<String, String> queryParams) {
        try {
            for (DownloadableResourceBuilder builder : this.builders) {
                if (!builder.matches(url)) continue;
                return builder.parse(url, queryParams);
            }
        }
        catch (UrlParseException e) {
            log.error("Unable to parse URL: " + url, (Throwable)e);
        }
        return null;
    }

    @Override
    public List<PluginResource> getPluginResources(String moduleCompleteKey) {
        ModuleDescriptor moduleDescriptor = this.pluginAccessor.getEnabledPluginModule(moduleCompleteKey);
        if (moduleDescriptor == null || !(moduleDescriptor instanceof WebResourceModuleDescriptor)) {
            log.error("Error loading resource \"" + moduleCompleteKey + "\". Resource is not a Web Resource Module");
            return Collections.emptyList();
        }
        boolean singleMode = !this.batchingConfiguration.isPluginWebResourceBatchingEnabled();
        ArrayList<PluginResource> resources = new ArrayList<PluginResource>();
        for (ResourceDescriptor resourceDescriptor : moduleDescriptor.getResourceDescriptors()) {
            if (singleMode || AbstractBatchResourceBuilder.skipBatch(resourceDescriptor)) {
                boolean cache = !"false".equalsIgnoreCase(resourceDescriptor.getParameter("cache"));
                resources.add(new SinglePluginResource(resourceDescriptor.getName(), moduleDescriptor.getCompleteKey(), cache, resourceDescriptor.getParameters()));
                continue;
            }
            BatchPluginResource batchResource = this.createBatchResource(moduleDescriptor.getCompleteKey(), resourceDescriptor);
            if (resources.contains(batchResource)) continue;
            resources.add(batchResource);
        }
        return resources;
    }

    String[] splitLastPathPart(String resourcePath) {
        int indexOfSlash = resourcePath.lastIndexOf(47);
        if (resourcePath.endsWith("/")) {
            indexOfSlash = resourcePath.lastIndexOf(47, indexOfSlash - 1);
        }
        if (indexOfSlash < 0) {
            return null;
        }
        return new String[]{resourcePath.substring(0, indexOfSlash + 1), resourcePath.substring(indexOfSlash + 1)};
    }

    private BatchPluginResource createBatchResource(String moduleCompleteKey, ResourceDescriptor resourceDescriptor) {
        String name = resourceDescriptor.getName();
        String type = name.substring(name.lastIndexOf(".") + 1);
        TreeMap<String, String> params = new TreeMap<String, String>();
        for (String param : BATCH_PARAMS) {
            String value = resourceDescriptor.getParameter(param);
            if (!StringUtils.isNotEmpty((String)value)) continue;
            params.put(param, value);
        }
        return new BatchPluginResource(moduleCompleteKey, type, params, Collections.<DownloadableResource>emptyList());
    }

    @Override
    public String getResourceUrl(String moduleCompleteKey, String resourceName) {
        return this.webResourceUrlProvider.getResourceUrl(moduleCompleteKey, resourceName);
    }
}

