/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.BatchSubResource;
import com.atlassian.plugin.webresource.DownloadableResourceBuilder;
import com.atlassian.plugin.webresource.DownloadableResourceFinder;
import com.atlassian.plugin.webresource.ResourceDependencyResolver;
import com.atlassian.plugin.webresource.ResourceUtils;
import com.atlassian.plugin.webresource.UrlParseException;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextBatchSubResourceBuilder
implements DownloadableResourceBuilder {
    public static final Pattern CONTEXT_BATCH_PATTERN = Pattern.compile("/download/contextbatch/\\w*/([^/]*)/(?!batch\\.js)(.*)$");
    private final ResourceDependencyResolver dependencyResolver;
    private final DownloadableResourceFinder resourceFinder;

    public ContextBatchSubResourceBuilder(ResourceDependencyResolver dependencyResolver, DownloadableResourceFinder resourceFinder) {
        this.dependencyResolver = dependencyResolver;
        this.resourceFinder = resourceFinder;
    }

    @Override
    public boolean matches(String path) {
        return CONTEXT_BATCH_PATTERN.matcher(path).find();
    }

    @Override
    public DownloadableResource parse(String path, Map<String, String> params) throws UrlParseException {
        Matcher m = CONTEXT_BATCH_PATTERN.matcher(path);
        if (!m.find()) {
            throw new UrlParseException("Context batch url could not be parsed.");
        }
        String key = m.group(1);
        String resourceName = m.group(2);
        String type = ResourceUtils.getType(path);
        for (String context : this.getContexts(key)) {
            for (WebResourceModuleDescriptor moduleDescriptor : this.dependencyResolver.getDependenciesInContext(context)) {
                DownloadableResource resource = this.resourceFinder.find(moduleDescriptor.getCompleteKey(), resourceName);
                if (resource == null) continue;
                return new BatchSubResource(resourceName, type, params, (List<DownloadableResource>)ImmutableList.of((Object)resource));
            }
        }
        return new BatchSubResource(resourceName, type, params);
    }

    private String[] getContexts(String key) {
        return key.split(",");
    }
}

