/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.Resources;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.util.EfficientStringUtils;
import com.atlassian.plugin.webresource.DownloadableResourceBuilder;
import com.atlassian.plugin.webresource.DownloadableResourceFinder;
import com.atlassian.plugin.webresource.PluginResourceLocator;
import com.atlassian.plugin.webresource.RelativeURLTransformResource;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractBatchResourceBuilder
implements DownloadableResourceBuilder {
    private static final Logger log = LoggerFactory.getLogger(AbstractBatchResourceBuilder.class);
    private static final String RESOURCE_SOURCE_PARAM = "source";
    private static final String RESOURCE_BATCH_PARAM = "batch";
    private static final String DOWNLOAD_TYPE = "download";
    private final PluginAccessor pluginAccessor;
    private final WebResourceUrlProvider webResourceUrlProvider;
    protected DownloadableResourceFinder resourceFinder;

    AbstractBatchResourceBuilder(PluginAccessor pluginAccessor, WebResourceUrlProvider webResourceUrlProvider, DownloadableResourceFinder resourceFinder) {
        this.pluginAccessor = pluginAccessor;
        this.webResourceUrlProvider = webResourceUrlProvider;
        this.resourceFinder = resourceFinder;
    }

    Iterable<DownloadableResource> resolve(String moduleKey, String batchType, Map<String, String> batchParams) {
        ModuleDescriptor desc = this.pluginAccessor.getEnabledPluginModule(moduleKey);
        if (desc == null) {
            log.info("Resource batching configuration refers to plugin that does not exist: {}", (Object)moduleKey);
            return Collections.emptyList();
        }
        log.debug("searching resources in: {}", (Object)moduleKey);
        return this.resolve(desc, batchType, batchParams);
    }

    Iterable<DownloadableResource> resolve(final ModuleDescriptor<?> moduleDescriptor, final String batchType, final Map<String, String> batchParams) {
        Iterable downloadDescriptors = Iterables.filter((Iterable)moduleDescriptor.getResourceDescriptors(), (Predicate)new Resources.TypeFilter(DOWNLOAD_TYPE));
        Iterable inBatch = Iterables.filter((Iterable)downloadDescriptors, (Predicate)new Predicate<ResourceDescriptor>(){

            public boolean apply(ResourceDescriptor resourceDescriptor) {
                return AbstractBatchResourceBuilder.this.isResourceInBatch(resourceDescriptor, batchType, batchParams);
            }
        });
        Iterable resources = Iterables.transform((Iterable)inBatch, (Function)new Function<ResourceDescriptor, DownloadableResource>(){

            public DownloadableResource apply(ResourceDescriptor from) {
                DownloadableResource result = AbstractBatchResourceBuilder.this.resourceFinder.find(moduleDescriptor.getCompleteKey(), from.getName());
                if (result != null && RelativeURLTransformResource.matches(from)) {
                    return new RelativeURLTransformResource(AbstractBatchResourceBuilder.this.webResourceUrlProvider, moduleDescriptor, result);
                }
                return result;
            }
        });
        return Iterables.filter((Iterable)resources, (Predicate)Predicates.notNull());
    }

    DownloadableResourceFinder getResourceFinder() {
        return this.resourceFinder;
    }

    private boolean isResourceInBatch(ResourceDescriptor resourceDescriptor, String batchType, Map<String, String> batchParams) {
        if (!this.descriptorTypeMatchesResourceType(resourceDescriptor, batchType)) {
            return false;
        }
        if (AbstractBatchResourceBuilder.skipBatch(resourceDescriptor)) {
            return false;
        }
        for (String param : PluginResourceLocator.BATCH_PARAMS) {
            String batchValue = batchParams.get(param);
            String resourceValue = resourceDescriptor.getParameter(param);
            if (batchValue == null && resourceValue != null) {
                return false;
            }
            if (batchValue == null || batchValue.equals(resourceValue)) continue;
            return false;
        }
        return true;
    }

    private boolean descriptorTypeMatchesResourceType(ResourceDescriptor resourceDescriptor, String type) {
        return EfficientStringUtils.endsWith((String)resourceDescriptor.getName(), (String[])new String[]{".", type});
    }

    static boolean skipBatch(ResourceDescriptor resourceDescriptor) {
        boolean doNotBatch = "false".equalsIgnoreCase(resourceDescriptor.getParameter(RESOURCE_BATCH_PARAM));
        return doNotBatch || "webContext".equalsIgnoreCase(resourceDescriptor.getParameter(RESOURCE_SOURCE_PARAM));
    }
}

