/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.transformer;

import com.atlassian.plugin.servlet.DownloadException;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.transformer.AppendableWriter;
import com.atlassian.plugin.webresource.transformer.WriterOutputStream;
import com.google.common.base.Function;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CharSequenceReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformerUtils {
    public static final Charset UTF8 = Charset.forName("UTF-8");

    public static void transformAndStreamResource(DownloadableResource originalResource, Charset encoding, OutputStream out, Function<CharSequence, CharSequence> transform) throws DownloadException {
        try {
            StringBuilder originalContent = new StringBuilder();
            WriterOutputStream output = new WriterOutputStream((Writer)new AppendableWriter(originalContent), encoding);
            originalResource.streamResource(output);
            output.flush();
            IOUtils.copy((Reader)new CharSequenceReader((CharSequence)transform.apply((Object)originalContent)), (OutputStream)out, (String)encoding.name());
        }
        catch (IOException e) {
            throw new DownloadException("Unable to stream to the output", e);
        }
    }
}

