/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.BatchSubResource;
import com.atlassian.plugin.webresource.DownloadableResourceBuilder;
import com.atlassian.plugin.webresource.DownloadableResourceFinder;
import com.atlassian.plugin.webresource.ResourceDependencyResolver;
import com.atlassian.plugin.webresource.ResourceUtils;
import com.atlassian.plugin.webresource.UrlParseException;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import java.util.Arrays;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuperBatchSubResourceBuilder
implements DownloadableResourceBuilder {
    private final ResourceDependencyResolver dependencyResolver;
    private final DownloadableResourceFinder resourceFinder;

    public SuperBatchSubResourceBuilder(ResourceDependencyResolver dependencyResolver, DownloadableResourceFinder resourceFinder) {
        this.dependencyResolver = dependencyResolver;
        this.resourceFinder = resourceFinder;
    }

    @Override
    public boolean matches(String path) {
        return path.indexOf("/download/superbatch/") > -1;
    }

    @Override
    public DownloadableResource parse(String path, Map<String, String> params) throws UrlParseException {
        String type = ResourceUtils.getType(path);
        String resourceName = this.getResourceName(path);
        for (WebResourceModuleDescriptor moduleDescriptor : this.dependencyResolver.getSuperBatchDependencies()) {
            DownloadableResource resource = this.resourceFinder.find(moduleDescriptor.getCompleteKey(), resourceName);
            if (resource == null) continue;
            return new BatchSubResource(resourceName, type, params, Arrays.asList(resource));
        }
        return new BatchSubResource(resourceName, type, params);
    }

    private String getResourceName(String path) {
        int startIndex = path.indexOf("/download/superbatch/") + "/download/superbatch/".length();
        return path.substring(startIndex);
    }
}

