/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.webresource.ContextBatch;
import com.atlassian.plugin.webresource.DefaultWebResourceFilter;
import com.atlassian.plugin.webresource.PluginResource;
import com.atlassian.plugin.webresource.PluginResourceLocator;
import com.atlassian.plugin.webresource.ResourceBatchingConfiguration;
import com.atlassian.plugin.webresource.ResourceDependencyResolver;
import com.atlassian.plugin.webresource.WebResourceFilter;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ContextBatchBuilder {
    private static final Logger log = LoggerFactory.getLogger(ContextBatchBuilder.class);
    private final PluginResourceLocator pluginResourceLocator;
    private final ResourceDependencyResolver dependencyResolver;
    private final ResourceBatchingConfiguration batchingConfiguration;
    private final List<String> allIncludedResources = new ArrayList<String>();
    private final Set<String> skippedResources = new HashSet<String>();

    ContextBatchBuilder(PluginResourceLocator pluginResourceLocator, ResourceDependencyResolver dependencyResolver, ResourceBatchingConfiguration batchingConfiguration) {
        this.pluginResourceLocator = pluginResourceLocator;
        this.dependencyResolver = dependencyResolver;
        this.batchingConfiguration = batchingConfiguration;
    }

    Iterable<PluginResource> build(Iterable<String> includedContexts) {
        return this.build(includedContexts, DefaultWebResourceFilter.INSTANCE);
    }

    Iterable<PluginResource> build(Iterable<String> includedContexts, WebResourceFilter filter) {
        if (!this.batchingConfiguration.isContextBatchingEnabled()) {
            return this.getUnbatchedResources(includedContexts, filter);
        }
        ArrayList<ContextBatch> batches = new ArrayList<ContextBatch>();
        for (String context : includedContexts) {
            ContextBatch contextBatch = new ContextBatch(context, this.dependencyResolver.getDependenciesInContext(context, this.skippedResources));
            ArrayList<ContextBatch> mergeList = new ArrayList<ContextBatch>();
            for (WebResourceModuleDescriptor contextResource : contextBatch.getResources()) {
                if (!this.allIncludedResources.contains(contextResource.getCompleteKey())) {
                    for (PluginResource pluginResource : this.pluginResourceLocator.getPluginResources(contextResource.getCompleteKey())) {
                        if (!filter.matches(pluginResource.getResourceName())) continue;
                        contextBatch.addResourceType(pluginResource);
                    }
                    this.allIncludedResources.add(contextResource.getCompleteKey());
                    continue;
                }
                for (ContextBatch batch : batches) {
                    if (mergeList.contains(batch) || !batch.isResourceIncluded(contextResource.getCompleteKey())) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("Context: {} shares a resource with {}: {}", (Object[])new String[]{context, batch.getKey(), contextResource.getCompleteKey()});
                    }
                    mergeList.add(batch);
                }
            }
            if (!mergeList.isEmpty()) {
                ContextBatch mergedBatch = (ContextBatch)mergeList.get(0);
                batches.remove(mergedBatch);
                for (int i = 1; i < mergeList.size(); ++i) {
                    ContextBatch mergingBatch = (ContextBatch)mergeList.get(i);
                    mergedBatch = ContextBatch.merge(mergedBatch, mergingBatch);
                    batches.remove(mergingBatch);
                }
                mergedBatch = ContextBatch.merge(mergedBatch, contextBatch);
                batches.add(mergedBatch);
                continue;
            }
            batches.add(contextBatch);
        }
        return Iterables.concat((Iterable)Iterables.transform(batches, (Function)new Function<ContextBatch, Iterable<PluginResource>>(){

            public Iterable<PluginResource> apply(ContextBatch batch) {
                return batch.buildPluginResources();
            }
        }));
    }

    private Iterable<PluginResource> getUnbatchedResources(Iterable<String> includedContexts, WebResourceFilter filter) {
        LinkedHashSet<PluginResource> includedResources = new LinkedHashSet<PluginResource>();
        for (String context : includedContexts) {
            Iterable<WebResourceModuleDescriptor> contextResources = this.dependencyResolver.getDependenciesInContext(context, this.skippedResources);
            for (WebResourceModuleDescriptor contextResource : contextResources) {
                if (this.allIncludedResources.contains(contextResource.getCompleteKey())) continue;
                List<PluginResource> moduleResources = this.pluginResourceLocator.getPluginResources(contextResource.getCompleteKey());
                for (PluginResource moduleResource : moduleResources) {
                    if (!filter.matches(moduleResource.getResourceName())) continue;
                    includedResources.add(moduleResource);
                }
                this.allIncludedResources.add(contextResource.getCompleteKey());
            }
        }
        return includedResources;
    }

    Iterable<String> getAllIncludedResources() {
        return this.allIncludedResources;
    }

    Iterable<String> getSkippedResources() {
        return this.skippedResources;
    }
}

