/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.webresource.BatchedWebResourceDescriptor;
import com.atlassian.plugin.webresource.PluginResource;
import com.atlassian.plugin.webresource.ResourceUtils;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class SinglePluginResource
implements PluginResource {
    static final String URL_PREFIX = "/download/resources";
    private final String resourceName;
    private final String moduleCompleteKey;
    private final boolean cached;
    private final Map<String, String> params;
    private final LazyReference<String> type;

    public SinglePluginResource(String resourceName, String moduleCompleteKey, boolean cached) {
        this(resourceName, moduleCompleteKey, cached, Collections.emptyMap());
    }

    public SinglePluginResource(final String resourceName, String moduleCompleteKey, boolean cached, Map<String, String> params) {
        this.resourceName = resourceName;
        this.moduleCompleteKey = moduleCompleteKey;
        this.cached = cached;
        this.params = ImmutableMap.copyOf(params);
        this.type = new LazyReference<String>(){

            protected String create() throws Exception {
                return ResourceUtils.getType(resourceName);
            }
        };
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    @Override
    public String getModuleCompleteKey() {
        return this.moduleCompleteKey;
    }

    @Override
    public Map<String, String> getParams() {
        return this.params;
    }

    @Override
    public String getVersion(WebResourceIntegration integration) {
        Plugin plugin = integration.getPluginAccessor().getEnabledPluginModule(this.getModuleCompleteKey()).getPlugin();
        return plugin.getPluginInformation().getVersion();
    }

    @Override
    public boolean isCacheSupported() {
        return this.cached;
    }

    @Override
    public Set<BatchedWebResourceDescriptor> getBatchedWebResourceDescriptors() {
        return Collections.emptySet();
    }

    @Override
    public String getUrl() {
        return "/download/resources/" + this.moduleCompleteKey + "/" + this.resourceName;
    }

    @Override
    public String getType() {
        return (String)this.type.get();
    }
}

