/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.servlet.DownloadException;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.CssWebResource;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.plugin.webresource.transformer.SearchAndReplacer;
import com.atlassian.plugin.webresource.transformer.TransformerUtils;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

final class RelativeURLTransformResource
implements DownloadableResource {
    static final Charset UTF8 = Charset.forName("UTF-8");
    static final Pattern CSS_URL_PATTERN = Pattern.compile("url\\s*\\(\\s*+([\"'])?+(?!/|https?://|data:)");
    static final Predicate<ResourceDescriptor> matcher = new Predicate<ResourceDescriptor>(){

        public boolean apply(ResourceDescriptor input) {
            return RelativeURLTransformResource.matches(input);
        }
    };
    private final DownloadableResource originalResource;
    private final LazyReference<String> urlPrefix;

    static boolean matches(ResourceDescriptor resource) {
        return CssWebResource.FORMATTER.matches(resource.getName());
    }

    RelativeURLTransformResource(final WebResourceUrlProvider webResourceUrlProvider, final ModuleDescriptor<?> moduleDescriptor, DownloadableResource originalResource) {
        this.originalResource = originalResource;
        this.urlPrefix = new LazyReference<String>(){

            protected String create() {
                String version = moduleDescriptor.getPlugin().getPluginInformation().getVersion();
                return webResourceUrlProvider.getStaticResourcePrefix(version, UrlMode.RELATIVE) + "/download/resources" + "/" + moduleDescriptor.getCompleteKey() + "/";
            }
        };
    }

    CharSequence transform(CharSequence originalContent) {
        Function<Matcher, CharSequence> replacer = new Function<Matcher, CharSequence>(){

            public CharSequence apply(Matcher matcher) {
                return new StringBuilder(matcher.group()).append((String)RelativeURLTransformResource.this.urlPrefix.get());
            }
        };
        return SearchAndReplacer.create(CSS_URL_PATTERN, replacer).replaceAll(originalContent);
    }

    @Override
    public boolean isResourceModified(HttpServletRequest request, HttpServletResponse response) {
        return this.originalResource.isResourceModified(request, response);
    }

    @Override
    public void serveResource(HttpServletRequest request, HttpServletResponse response) throws DownloadException {
        String contentType = this.getContentType();
        if (StringUtils.isNotBlank((String)contentType)) {
            response.setContentType(contentType);
        }
        try {
            this.streamResource((OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            throw new DownloadException(e);
        }
    }

    @Override
    public void streamResource(OutputStream out) throws DownloadException {
        TransformerUtils.transformAndStreamResource(this.originalResource, UTF8, out, new Function<CharSequence, CharSequence>(){

            public CharSequence apply(CharSequence originalContent) {
                return RelativeURLTransformResource.this.transform(originalContent);
            }
        });
    }

    @Override
    public String getContentType() {
        return this.originalResource.getContentType();
    }
}

