/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.ContextBatchOperations;
import com.atlassian.plugin.webresource.DownloadableResourceBuilder;
import com.atlassian.plugin.webresource.DownloadableResourceFinder;
import com.atlassian.plugin.webresource.ResourceDependencyResolver;
import com.atlassian.plugin.webresource.UrlParseException;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ContextBatchSubResourceBuilder
implements DownloadableResourceBuilder {
    public static final Pattern CONTEXT_BATCH_PATTERN = Pattern.compile("/download/contextbatch/\\w*/([^/]*)/(?!batch\\.js)(.*)$");
    private final ResourceDependencyResolver dependencyResolver;
    private final DownloadableResourceFinder resourceFinder;

    public ContextBatchSubResourceBuilder(ResourceDependencyResolver dependencyResolver, DownloadableResourceFinder resourceFinder) {
        this.dependencyResolver = dependencyResolver;
        this.resourceFinder = resourceFinder;
    }

    @Override
    public boolean matches(String path) {
        return CONTEXT_BATCH_PATTERN.matcher(path).find();
    }

    @Override
    public DownloadableResource parse(String path, Map<String, String> params) throws UrlParseException {
        Matcher m = CONTEXT_BATCH_PATTERN.matcher(path);
        if (!m.find()) {
            throw new UrlParseException("Context batch url could not be parsed.");
        }
        String key = m.group(1);
        String resourceName = m.group(2);
        LinkedHashSet<String> includedContexts = new LinkedHashSet<String>();
        HashSet<String> excludedContexts = new HashSet<String>();
        ContextBatchOperations.parseContexts(key, includedContexts, excludedContexts);
        for (String context : includedContexts) {
            for (WebResourceModuleDescriptor moduleDescriptor : this.dependencyResolver.getDependenciesInContext(context)) {
                DownloadableResource resource = this.resourceFinder.find(moduleDescriptor.getCompleteKey(), resourceName);
                if (resource == null) continue;
                return resource;
            }
        }
        return null;
    }
}

