package com.atlassian.plugin.webresource;

import java.util.Map;
import java.util.Set;

/**
 * Represents a plugin resource.
 * This object represents a page-time resource. It is used build a URL to the underlying resource,
 * but does not know how to get the contents of that resource itself.
 *
 * @since 2.2
 */
public interface PluginResource
{
    /**
     * @return true if caching for this resource is supported. Use this check to append a static
     * caching url prefix to this resource's url.
     */
    boolean isCacheSupported();

    /**
     * @return the url for this plugin resource.
     */
    String getUrl();

    /**
     * @return the resource name for the plugin resource.
     */
    String getResourceName();

    /**
     * @return the plugin module's complete key for which this resource belongs to.
     */
    String getModuleCompleteKey();

    /**
     * @return a map of parameter key and value pairs for this resource.
     */
    Map<String, String> getParams();

    /**
     * @return the version prefix string for a cached resource
     */
    String getVersion(WebResourceIntegration integration);

    /**
     * @return the type (e.g. file extension) of the resource.
     * @since 2.12.3
     */
    String getType();
    
    /**
     * This method provides the mechanism for discovering the contents of a PluginResource.
     * <p/>
     * The primary use of this method is in providing a representation of the contents 
     * (for dependency tracking) when formatting a PluginResource.
     * 
     * @return a Set of descriptors providing information about the contents of this PluginResource.
     */
    Set<BatchedWebResourceDescriptor> getBatchedWebResourceDescriptors();
}