/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.webresource.PluginResource;
import com.atlassian.plugin.webresource.ResourceUtils;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class SuperBatchPluginResource
implements PluginResource {
    static final String URL_PREFIX = "/download/superbatch/";
    static final String DEFAULT_RESOURCE_NAME_PREFIX = "batch";
    private final String resourceName;
    private final String type;
    private final Map<String, String> params;

    public static SuperBatchPluginResource createBatchFor(PluginResource pluginResource) {
        return new SuperBatchPluginResource(ResourceUtils.getType(pluginResource.getResourceName()), pluginResource.getParams());
    }

    public SuperBatchPluginResource(String type, Map<String, String> params) {
        this("batch." + type, type, params);
    }

    protected SuperBatchPluginResource(String resourceName, String type, Map<String, String> params) {
        this.resourceName = resourceName;
        this.type = type;
        this.params = ImmutableMap.copyOf(params);
    }

    @Override
    public String getUrl() {
        StringBuilder buf = new StringBuilder(URL_PREFIX.length() + 20);
        buf.append(URL_PREFIX).append(this.getType()).append("/").append(this.resourceName);
        ResourceUtils.addParamsToUrl(buf, this.getParams());
        return buf.toString();
    }

    @Override
    public Map<String, String> getParams() {
        return this.params;
    }

    @Override
    public String getVersion(WebResourceIntegration integration) {
        return integration.getSuperBatchVersion();
    }

    public String getType() {
        return this.type;
    }

    @Override
    public boolean isCacheSupported() {
        return true;
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    @Override
    public String getModuleCompleteKey() {
        return "superbatch";
    }

    public String toString() {
        return "[Superbatch name=" + this.resourceName + ", type=" + this.getType() + ", params=" + this.getParams() + "]";
    }
}

