/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.cache.filecache.FileCache;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.util.EfficientStringUtils;
import com.atlassian.plugin.webresource.AbstractBatchResourceBuilder;
import com.atlassian.plugin.webresource.DownloadableResourceFinder;
import com.atlassian.plugin.webresource.ResourceDependencyResolver;
import com.atlassian.plugin.webresource.ResourceUtils;
import com.atlassian.plugin.webresource.SuperBatchDownloadableResource;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.plugin.webresource.cache.CacheHandle;
import com.atlassian.plugin.webresource.cache.FileCacheKey;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Map;

class SuperBatchDownloadableResourceBuilder
extends AbstractBatchResourceBuilder {
    private final ResourceDependencyResolver dependencyResolver;

    public SuperBatchDownloadableResourceBuilder(ResourceDependencyResolver dependencyResolver, PluginAccessor pluginAccessor, WebResourceUrlProvider webResourceUrlProvider, DownloadableResourceFinder resourceFinder, FileCache<FileCacheKey> cache) {
        super(pluginAccessor, webResourceUrlProvider, resourceFinder, cache);
        this.dependencyResolver = dependencyResolver;
    }

    @Override
    public boolean matches(String path) {
        String type = ResourceUtils.getType(path);
        return path.indexOf("/download/superbatch/") != -1 && EfficientStringUtils.endsWith((String)path, (String[])new String[]{"batch", ".", type});
    }

    @Override
    public SuperBatchDownloadableResource parse(String path, Map<String, String> params) {
        String type = ResourceUtils.getType(path);
        Object resources = ImmutableList.of();
        for (WebResourceModuleDescriptor moduleDescriptor : this.dependencyResolver.getSuperBatchDependencies()) {
            resources = Iterables.concat((Iterable)resources, this.resolve((ModuleDescriptor<?>)moduleDescriptor, type, params));
        }
        return new SuperBatchDownloadableResource(type, params, (Iterable<DownloadableResource>)resources, CacheHandle.Builder.forRequest(this.cache, "superbatch", path, params));
    }
}

