/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.webresource.PluginResource;
import com.atlassian.plugin.webresource.ResourceUtils;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

class ContextBatchPluginResource
implements PluginResource {
    static final String URL_PREFIX = "/download/contextbatch/";
    static final String DEFAULT_RESOURCE_NAME_PREFIX = "batch";
    private final String resourceName;
    private final String key;
    private final String hash;
    private final String type;
    private final Map<String, String> params;

    ContextBatchPluginResource(String key, String hash, String type, Map<String, String> params) {
        this.type = type;
        this.params = ImmutableMap.copyOf(params);
        this.resourceName = "batch." + type;
        this.key = key;
        this.hash = hash;
    }

    @Override
    public String getUrl() {
        StringBuilder buf = new StringBuilder(URL_PREFIX.length() + 20);
        buf.append(URL_PREFIX).append(this.type).append("/").append(this.key).append("/").append(this.resourceName);
        ResourceUtils.addParamsToUrl(buf, this.getParams());
        return buf.toString();
    }

    @Override
    public Map<String, String> getParams() {
        return this.params;
    }

    @Override
    public String getVersion(WebResourceIntegration integration) {
        return this.hash;
    }

    @Override
    public boolean isCacheSupported() {
        return true;
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    @Override
    public String getModuleCompleteKey() {
        return "contextbatch-" + this.resourceName;
    }

    public String toString() {
        return "[Context Batch name=" + this.resourceName + ", type=" + this.type + ", params=" + this.params + "]";
    }
}

