/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webresource.plugin.prebake.discovery;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.webresource.api.assembler.AssembledResources;
import com.atlassian.webresource.api.assembler.WebResource;
import com.atlassian.webresource.api.assembler.WebResourceSet;
import com.atlassian.webresource.api.assembler.resource.PluginCssResource;
import com.atlassian.webresource.api.assembler.resource.PluginJsResource;
import com.atlassian.webresource.api.assembler.resource.PluginUrlResource;
import com.atlassian.webresource.plugin.prebake.resources.PluginResource;
import com.atlassian.webresource.plugin.prebake.resources.Resource;
import java.util.List;
import java.util.concurrent.BlockingQueue;

@ExperimentalApi
public interface WebResourceCrawler {
    public void crawl(BlockingQueue<Resource> var1) throws InterruptedException;

    public List<String> getTargets();

    default public void crawlAssembledResource(AssembledResources source, BlockingQueue<Resource> destination) throws InterruptedException {
        WebResourceSet webResourceSet;
        do {
            webResourceSet = source.pollIncludedResources();
            for (WebResource resource : webResourceSet.getResources()) {
                if (!(resource instanceof PluginJsResource) && !(resource instanceof PluginCssResource)) continue;
                PluginResource pr = new PluginResource((PluginUrlResource)resource);
                destination.put(pr);
            }
        } while (!webResourceSet.isComplete());
    }
}

