/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webresource.plugin.rest;

import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.webresource.plugin.async.AsyncWebResourceLoader;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@AnonymousAllowed
@Path(value="resources")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ListOfResources {
    private final AsyncWebResourceLoader asyncWebResourceLoader;

    public ListOfResources(AsyncWebResourceLoader asyncWebResourceLoader) {
        this.asyncWebResourceLoader = asyncWebResourceLoader;
    }

    @GET
    public Iterable<AsyncWebResourceLoader.Resource> list(@QueryParam(value="r") String webResources, @QueryParam(value="c") String contexts, @QueryParam(value="xr") String excludeResources, @QueryParam(value="xc") String excludeContexts) {
        return this.asyncWebResourceLoader.resolve(this.asSet(webResources), this.asSet(contexts), this.asSet(excludeResources), this.asSet(excludeContexts));
    }

    private Set<String> asSet(String str) {
        if (null == str || "".equals(str)) {
            return Collections.emptySet();
        }
        return Sets.newLinkedHashSet(Arrays.asList(str.split(",")));
    }
}

