/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webresource.plugin.async;

import com.atlassian.webresource.api.UrlMode;
import com.atlassian.webresource.api.assembler.WebResource;
import com.atlassian.webresource.api.assembler.WebResourceAssembler;
import com.atlassian.webresource.api.assembler.WebResourceAssemblerFactory;
import com.atlassian.webresource.api.assembler.WebResourceSet;
import com.atlassian.webresource.api.assembler.resource.PluginCssResource;
import com.atlassian.webresource.api.assembler.resource.PluginCssResourceParams;
import com.atlassian.webresource.api.assembler.resource.PluginJsResource;
import com.atlassian.webresource.api.assembler.resource.PluginJsResourceParams;
import com.atlassian.webresource.plugin.async.AsyncWebResourceLoader;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncWebResourceLoaderImpl
implements AsyncWebResourceLoader {
    private static final Logger logger = LoggerFactory.getLogger(AsyncWebResourceLoaderImpl.class);
    private final WebResourceAssemblerFactory webResourceAssemblerFactory;

    public AsyncWebResourceLoaderImpl(WebResourceAssemblerFactory webResourceAssemblerFactory) {
        this.webResourceAssemblerFactory = webResourceAssemblerFactory;
    }

    @Override
    public Iterable<AsyncWebResourceLoader.Resource> resolve(Set<String> webResources, Set<String> contexts, Set<String> excludeResources, Set<String> excludeContexts) {
        WebResourceSet webResourceSet = this.resolveWebResourceSet(webResources, contexts, excludeResources, excludeContexts);
        ArrayList resources = Lists.newArrayList();
        for (WebResource webResource : webResourceSet.getResources()) {
            if (webResource instanceof PluginJsResource) {
                PluginJsResource jsResource = (PluginJsResource)webResource;
                resources.add(new AsyncWebResourceLoader.Resource(jsResource.getStaticUrl(UrlMode.RELATIVE), AsyncWebResourceLoader.ResourceType.JAVASCRIPT, ((PluginJsResourceParams)jsResource.getParams()).conditionalComment(), ((PluginJsResourceParams)jsResource.getParams()).ieOnly()));
                continue;
            }
            if (!(webResource instanceof PluginCssResource)) continue;
            PluginCssResource cssResource = (PluginCssResource)webResource;
            resources.add(new AsyncWebResourceLoader.Resource(cssResource.getStaticUrl(UrlMode.RELATIVE), AsyncWebResourceLoader.ResourceType.CSS, ((PluginCssResourceParams)cssResource.getParams()).conditionalComment(), ((PluginCssResourceParams)cssResource.getParams()).ieOnly()));
        }
        return resources;
    }

    private WebResourceSet resolveWebResourceSet(Set<String> webResources, Set<String> contexts, Set<String> excludeResources, Set<String> excludeContexts) {
        if (logger.isDebugEnabled()) {
            logger.debug("Requiring webresources {}", webResources);
            logger.debug("Requiring contexts {}", contexts);
            logger.debug("Excluding webresource {}", excludeResources);
            logger.debug("Excluding contexts {}", excludeContexts);
        }
        WebResourceAssembler assembler = this.webResourceAssemblerFactory.create().build();
        assembler.resources().exclude(excludeResources, excludeContexts);
        for (String webResource : webResources) {
            assembler.resources().requireWebResource(webResource);
        }
        for (String context : contexts) {
            assembler.resources().requireContext(context);
        }
        return assembler.assembled().drainIncludedResources();
    }
}

