package com.atlassian.webresource.api.assembler;

import com.atlassian.annotations.ExperimentalApi;

/**
 * Service for working with the page being rendered by the current HTTP request.
 * <p/>
 * Note, {@link WebResourceAssembler} is currently an experimental API and may break between versions of web resources.
 * It is advised that you use {@link com.atlassian.plugin.webresource.WebResourceManager} in the mean time if you
 * require a stable API.
 *
 * @since v3.0
 */
@ExperimentalApi
public interface PageBuilderService
{
    /**
     * Retrieves the request-local WebResourceAssembler. If none is found, a new instance is constructed and stored in the
     * request-local cached.
     */
    public WebResourceAssembler assembler();
}
