/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.web.descriptors;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.util.validation.ValidationException;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.api.provider.WebSectionProvider;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.ArrayList;
import javax.annotation.Nonnull;

public class WebSectionProviderModuleDescriptor
extends AbstractModuleDescriptor<WebSectionProvider>
implements com.atlassian.plugin.web.api.descriptors.WebSectionProviderModuleDescriptor<WebSectionProvider> {
    private final WebInterfaceManager webInterfaceManager;
    private Supplier<WebSectionProvider> sectionSupplier;
    private String location;

    public WebSectionProviderModuleDescriptor(ModuleFactory moduleFactory, WebInterfaceManager webInterfaceManager) {
        super(moduleFactory);
        this.webInterfaceManager = webInterfaceManager;
    }

    protected void validate(Element element) {
        super.validate(element);
        ArrayList<String> violations = new ArrayList<String>();
        if (element.attributeValue("class") == null) {
            violations.add("The web section provider class is required");
        }
        if (element.attributeValue("location") == null) {
            violations.add("Must provide a location that sections should be added to.");
        }
        if (!violations.isEmpty()) {
            throw new ValidationException("There were validation errors:", violations);
        }
    }

    public void init(@Nonnull Plugin plugin, @Nonnull Element element) throws PluginParseException {
        super.init(plugin, element);
        final WebSectionProviderModuleDescriptor that = this;
        this.sectionSupplier = Suppliers.memoize((Supplier)new Supplier<WebSectionProvider>(){

            public WebSectionProvider get() {
                return (WebSectionProvider)WebSectionProviderModuleDescriptor.this.moduleFactory.createModule(WebSectionProviderModuleDescriptor.this.moduleClassName, (ModuleDescriptor)that);
            }
        });
        this.location = element.attributeValue("location");
    }

    public String getLocation() {
        return this.location;
    }

    public WebSectionProvider getModule() {
        return (WebSectionProvider)this.sectionSupplier.get();
    }

    public void enabled() {
        super.enabled();
        this.webInterfaceManager.refresh();
    }

    public void disabled() {
        super.disabled();
        this.webInterfaceManager.refresh();
    }
}

