/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.web.analytics;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.annotations.VisibleForTesting;
import java.util.zip.CRC32;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@EventName(value="web.fragment.condition.evaluate.time")
public class ConditionEvaluateTimeEvent {
    private static final int ANALYTIC_EVENT_VERSION = 1;
    private static final String ATLASSIAN_PACKAGE_PREFIX = "com.atlassian";
    private final boolean atlassianPlugin;
    private final long evaluationTimeMilliseconds;
    private final String fragmentLocation;
    private final long pluginKeyResponsible;
    private final boolean successfullyEvaluatedCondition;

    public ConditionEvaluateTimeEvent(@Nullable String fragmentLocation, @Nonnull String pluginKeyResponsible, boolean successfullyEvaluatedCondition, long timeAtStartOfEvaluationInMillis, long timeAtEndOfEvaluationInMillis) {
        this.atlassianPlugin = ConditionEvaluateTimeEvent.isAtlassianPlugin(pluginKeyResponsible);
        this.fragmentLocation = fragmentLocation;
        this.pluginKeyResponsible = ConditionEvaluateTimeEvent.hashPluginKeyString(pluginKeyResponsible);
        this.successfullyEvaluatedCondition = successfullyEvaluatedCondition;
        this.evaluationTimeMilliseconds = timeAtEndOfEvaluationInMillis - timeAtStartOfEvaluationInMillis;
    }

    @VisibleForTesting
    static long hashPluginKeyString(@Nonnull String pluginKey) {
        CRC32 crc32 = new CRC32();
        crc32.update(pluginKey.getBytes(), 0, pluginKey.length());
        return crc32.getValue();
    }

    @VisibleForTesting
    static boolean isAtlassianPlugin(@Nonnull String pluginKey) {
        return pluginKey.startsWith(ATLASSIAN_PACKAGE_PREFIX);
    }

    public int getAnalyticEventVersion() {
        return 1;
    }

    public boolean getAtlassianPlugin() {
        return this.atlassianPlugin;
    }

    public long getPluginKeyResponsible() {
        return this.pluginKeyResponsible;
    }

    public boolean getSuccessfullyEvaluatedCondition() {
        return this.successfullyEvaluatedCondition;
    }

    public long getEvaluationTimeMilliseconds() {
        return this.evaluationTimeMilliseconds;
    }

    public String getFragmentLocation() {
        return this.fragmentLocation;
    }
}

