/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.web;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginManager;
import com.atlassian.plugin.web.WebFragmentHelper;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.ConditionalDescriptor;
import com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor;
import com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor;
import com.atlassian.plugin.web.descriptors.WebSectionModuleDescriptor;
import com.atlassian.plugin.web.descriptors.WeightedDescriptorComparator;
import com.atlassian.plugin.web.model.WebPanel;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWebInterfaceManager
implements WebInterfaceManager {
    private PluginAccessor pluginAccessor;
    private WebFragmentHelper webFragmentHelper;
    private Map<String, List<WebSectionModuleDescriptor>> sections;
    private Map<String, List<WebItemModuleDescriptor>> items;
    private Map<String, List<WebPanelModuleDescriptor>> panels;
    private static final Logger log = LoggerFactory.getLogger(DefaultWebInterfaceManager.class);
    public static final WeightedDescriptorComparator WEIGHTED_DESCRIPTOR_COMPARATOR = new WeightedDescriptorComparator();

    public DefaultWebInterfaceManager() {
        this.refresh();
    }

    public DefaultWebInterfaceManager(PluginAccessor pluginAccessor, WebFragmentHelper webFragmentHelper) {
        this.pluginAccessor = pluginAccessor;
        this.webFragmentHelper = webFragmentHelper;
        this.refresh();
    }

    @Override
    public boolean hasSectionsForLocation(String location) {
        return !this.getSections(location).isEmpty();
    }

    @Override
    public List<WebSectionModuleDescriptor> getSections(String location) {
        if (location == null) {
            return Collections.emptyList();
        }
        List<WebSectionModuleDescriptor> result = this.sections.get(location);
        if (result == null) {
            result = new ArrayList<WebSectionModuleDescriptor>();
            List descriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(WebSectionModuleDescriptor.class);
            for (WebSectionModuleDescriptor descriptor : descriptors) {
                if (!location.equalsIgnoreCase(descriptor.getLocation())) continue;
                result.add(descriptor);
            }
            Collections.sort(result, WEIGHTED_DESCRIPTOR_COMPARATOR);
            this.sections.put(location, result);
        }
        return result;
    }

    @Override
    public List<WebSectionModuleDescriptor> getDisplayableSections(String location, Map<String, Object> context) {
        return this.filterFragmentsByCondition(this.getSections(location), context);
    }

    @Override
    public List<WebItemModuleDescriptor> getItems(String section) {
        if (section == null) {
            return Collections.emptyList();
        }
        List<WebItemModuleDescriptor> result = this.items.get(section);
        if (result == null) {
            result = new ArrayList<WebItemModuleDescriptor>();
            List descriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(WebItemModuleDescriptor.class);
            for (WebItemModuleDescriptor descriptor : descriptors) {
                if (!section.equalsIgnoreCase(descriptor.getSection())) continue;
                result.add(descriptor);
            }
            Collections.sort(result, WEIGHTED_DESCRIPTOR_COMPARATOR);
            this.items.put(section, result);
        }
        return result;
    }

    @Override
    public List<WebItemModuleDescriptor> getDisplayableItems(String section, Map<String, Object> context) {
        return this.filterFragmentsByCondition(this.getItems(section), context);
    }

    @Override
    public List<WebPanel> getDisplayableWebPanels(String location, Map<String, Object> context) {
        return this.toWebPanels(this.getDisplayableWebPanelDescriptors(location, context));
    }

    @Override
    public List<WebPanelModuleDescriptor> getDisplayableWebPanelDescriptors(String location, Map<String, Object> context) {
        return this.filterFragmentsByCondition(this.getWebPanelDescriptors(location), context);
    }

    @Override
    public List<WebPanel> getWebPanels(String location) {
        return this.toWebPanels(this.getWebPanelDescriptors(location));
    }

    private List<WebPanel> toWebPanels(List<WebPanelModuleDescriptor> descriptors) {
        return Lists.transform(descriptors, (Function)new Function<WebPanelModuleDescriptor, WebPanel>(){

            public WebPanel apply(WebPanelModuleDescriptor from) {
                return (WebPanel)from.getModule();
            }
        });
    }

    @Override
    public List<WebPanelModuleDescriptor> getWebPanelDescriptors(String location) {
        if (location == null) {
            return Collections.emptyList();
        }
        List<WebPanelModuleDescriptor> result = this.panels.get(location);
        if (result == null) {
            result = new ArrayList<WebPanelModuleDescriptor>();
            List descriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(WebPanelModuleDescriptor.class);
            for (WebPanelModuleDescriptor descriptor : descriptors) {
                if (!location.equalsIgnoreCase(descriptor.getLocation())) continue;
                result.add(descriptor);
            }
            Collections.sort(result, WEIGHTED_DESCRIPTOR_COMPARATOR);
            this.panels.put(location, result);
        }
        return result;
    }

    private <T extends ConditionalDescriptor> List<T> filterFragmentsByCondition(List<T> relevantItems, Map<String, Object> context) {
        if (relevantItems.isEmpty()) {
            return relevantItems;
        }
        ArrayList<T> result = new ArrayList<T>(relevantItems);
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            ConditionalDescriptor descriptor = (ConditionalDescriptor)iterator.next();
            try {
                if (descriptor.getCondition() == null || descriptor.getCondition().shouldDisplay(context)) continue;
                iterator.remove();
            }
            catch (Throwable t) {
                log.error("Could not evaluate condition '" + descriptor.getCondition() + "' for descriptor: " + descriptor, t);
                iterator.remove();
            }
        }
        return result;
    }

    @Override
    public void refresh() {
        this.sections = Collections.synchronizedMap(new HashMap());
        this.items = Collections.synchronizedMap(new HashMap());
        this.panels = Collections.synchronizedMap(new HashMap());
    }

    @Deprecated
    public void setPluginManager(PluginManager pluginManager) {
        this.setPluginAccessor((PluginAccessor)pluginManager);
    }

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public void setWebFragmentHelper(WebFragmentHelper webFragmentHelper) {
        this.webFragmentHelper = webFragmentHelper;
    }

    @Override
    public WebFragmentHelper getWebFragmentHelper() {
        return this.webFragmentHelper;
    }
}

