/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.web.model;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.web.model.AbstractWebPanel;
import com.google.common.base.Preconditions;
import java.io.StringWriter;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceTemplateWebPanel
extends AbstractWebPanel {
    private static final Logger logger = LoggerFactory.getLogger((String)ResourceTemplateWebPanel.class.getName());
    private String resourceFilename;

    public ResourceTemplateWebPanel(PluginAccessor pluginAccessor) {
        super(pluginAccessor);
    }

    public void setResourceFilename(String resourceFilename) {
        this.resourceFilename = (String)Preconditions.checkNotNull((Object)resourceFilename, (Object)"resourceFilename");
    }

    @Override
    public String getHtml(Map<String, Object> context) {
        try {
            StringWriter sink = new StringWriter();
            this.getRenderer().render(this.resourceFilename, this.plugin, context, sink);
            return sink.toString();
        }
        catch (Exception e) {
            String message = String.format("Error rendering WebPanel (%s): %s", this.resourceFilename, e.getMessage());
            logger.warn(message, (Throwable)e);
            return message;
        }
    }
}

