/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.web.model;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.plugin.web.WebFragmentHelper;
import com.atlassian.plugin.web.descriptors.WebFragmentModuleDescriptor;
import com.atlassian.plugin.web.model.DefaultWebParam;
import com.atlassian.plugin.web.model.WebLabel;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWebLabel
extends DefaultWebParam
implements WebLabel {
    String key;
    String noKeyValue;

    public DefaultWebLabel(Element labelEl, WebFragmentHelper webFragmentHelper, ContextProvider contextProvider, WebFragmentModuleDescriptor descriptor) throws PluginParseException {
        super(labelEl, webFragmentHelper, contextProvider, descriptor);
        if (labelEl == null) {
            throw new PluginParseException("You must specify a label for the section.");
        }
        this.key = labelEl.attributeValue("key");
        if (this.key == null) {
            this.noKeyValue = labelEl.getTextTrim();
        }
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getNoKeyValue() {
        return this.noKeyValue;
    }

    @Override
    public String getDisplayableLabel(HttpServletRequest req, Map<String, Object> context) {
        context.putAll(this.getContextMap(context));
        if (this.key != null) {
            if (this.params == null || this.params.isEmpty()) {
                return this.getWebFragmentHelper().getI18nValue(this.key, null, context);
            }
            ArrayList<String> arguments = new ArrayList<String>();
            for (String key : this.params.keySet()) {
                if (!key.startsWith("param")) continue;
                arguments.add(this.getWebFragmentHelper().renderVelocityFragment((String)this.params.get(key), context));
            }
            return this.getWebFragmentHelper().getI18nValue(this.key, arguments, context);
        }
        return this.getWebFragmentHelper().renderVelocityFragment(this.noKeyValue, context);
    }
}

