/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.web;

import com.atlassian.plugin.PluginManager;
import com.atlassian.plugin.web.WebFragmentHelper;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebFragmentModuleDescriptor;
import com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor;
import com.atlassian.plugin.web.descriptors.WebSectionModuleDescriptor;
import com.atlassian.plugin.web.descriptors.WeightedDescriptorComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWebInterfaceManager
implements WebInterfaceManager {
    private PluginManager pluginManager;
    private WebFragmentHelper webFragmentHelper;
    private Map<String, List<WebSectionModuleDescriptor>> sections;
    private Map<String, List<WebItemModuleDescriptor>> items;
    private static final Log log = LogFactory.getLog(DefaultWebInterfaceManager.class);
    public static final WeightedDescriptorComparator WEIGHTED_DESCRIPTOR_COMPARATOR = new WeightedDescriptorComparator();

    public DefaultWebInterfaceManager() {
        this.refresh();
    }

    public DefaultWebInterfaceManager(PluginManager pluginManager, WebFragmentHelper webFragmentHelper) {
        this.pluginManager = pluginManager;
        this.webFragmentHelper = webFragmentHelper;
        this.refresh();
    }

    @Override
    public boolean hasSectionsForLocation(String location) {
        return !this.getSections(location).isEmpty();
    }

    @Override
    public List<WebSectionModuleDescriptor> getSections(String location) {
        if (location == null) {
            return Collections.emptyList();
        }
        List<WebSectionModuleDescriptor> result = this.sections.get(location);
        if (result == null) {
            result = new ArrayList<WebSectionModuleDescriptor>();
            List descriptors = this.pluginManager.getEnabledModuleDescriptorsByClass(WebSectionModuleDescriptor.class);
            for (WebSectionModuleDescriptor descriptor : descriptors) {
                if (!location.equalsIgnoreCase(descriptor.getLocation())) continue;
                result.add(descriptor);
            }
            Collections.sort(result, WEIGHTED_DESCRIPTOR_COMPARATOR);
            this.sections.put(location, result);
        }
        return result;
    }

    @Override
    public List<WebSectionModuleDescriptor> getDisplayableSections(String location, Map<String, Object> context) {
        return this.filterFragmentsByCondition(this.getSections(location), context);
    }

    @Override
    public List<WebItemModuleDescriptor> getItems(String section) {
        if (section == null) {
            return Collections.emptyList();
        }
        List<WebItemModuleDescriptor> result = this.items.get(section);
        if (result == null) {
            result = new ArrayList<WebItemModuleDescriptor>();
            List descriptors = this.pluginManager.getEnabledModuleDescriptorsByClass(WebItemModuleDescriptor.class);
            for (WebItemModuleDescriptor descriptor : descriptors) {
                if (!section.equalsIgnoreCase(descriptor.getSection())) continue;
                result.add(descriptor);
            }
            Collections.sort(result, WEIGHTED_DESCRIPTOR_COMPARATOR);
            this.items.put(section, result);
        }
        return result;
    }

    @Override
    public List<WebItemModuleDescriptor> getDisplayableItems(String section, Map<String, Object> context) {
        return this.filterFragmentsByCondition(this.getItems(section), context);
    }

    private <T extends WebFragmentModuleDescriptor> List<T> filterFragmentsByCondition(List<T> relevantItems, Map<String, Object> context) {
        if (relevantItems.isEmpty()) {
            return relevantItems;
        }
        ArrayList<T> result = new ArrayList<T>(relevantItems);
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            WebFragmentModuleDescriptor descriptor = (WebFragmentModuleDescriptor)iterator.next();
            try {
                if (descriptor.getCondition() == null || descriptor.getCondition().shouldDisplay(context)) continue;
                iterator.remove();
            }
            catch (Throwable t) {
                log.error((Object)("Could not evaluate condition '" + descriptor.getCondition() + "' for descriptor: " + descriptor), t);
                iterator.remove();
            }
        }
        return result;
    }

    @Override
    public void refresh() {
        this.sections = Collections.synchronizedMap(new HashMap());
        this.items = Collections.synchronizedMap(new HashMap());
    }

    public void setPluginManager(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    public void setWebFragmentHelper(WebFragmentHelper webFragmentHelper) {
        this.webFragmentHelper = webFragmentHelper;
    }

    @Override
    public WebFragmentHelper getWebFragmentHelper() {
        return this.webFragmentHelper;
    }
}

