/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.pluginns;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.BeanDefinitionDecorator;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginInterfaceBeanDefinitionDecorator
implements BeanDefinitionDecorator {
    public BeanDefinitionHolder decorate(Node source, BeanDefinitionHolder holder, ParserContext ctx) {
        String inf = source.getTextContent();
        if (inf != null) {
            inf = inf.trim();
        }
        BeanDefinitionRegistry registry = ctx.getRegistry();
        BeanDefinition providerDef = registry.getBeanDefinition("hostComponentProvider");
        List<String> interfaces = this.loadBeanInterfaces(providerDef, holder.getBeanName());
        interfaces.add(inf);
        return holder;
    }

    private List<String> loadBeanInterfaces(BeanDefinition providerDef, String beanName) {
        Map<String, List<String>> interfaces = this.loadInterfaceMap(providerDef);
        if (!interfaces.containsKey(beanName)) {
            interfaces.put(beanName, new ArrayList());
        }
        return interfaces.get(beanName);
    }

    private Map<String, List<String>> loadInterfaceMap(BeanDefinition providerDef) {
        HashMap<String, List<String>> interfaces;
        if (providerDef.getPropertyValues().contains("interfaces")) {
            interfaces = (Map)providerDef.getPropertyValues().getPropertyValue("interfaces").getValue();
        } else {
            interfaces = new HashMap();
            providerDef.getPropertyValues().addPropertyValue("interfaces", interfaces);
        }
        return interfaces;
    }
}

