/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.servlet.descriptors;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.RequirePermission;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.util.validation.ValidationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequirePermission(value={"execute_java"})
public abstract class BaseServletModuleDescriptor<T>
extends AbstractModuleDescriptor<T> {
    protected static final Logger log = LoggerFactory.getLogger(BaseServletModuleDescriptor.class);
    private List<String> paths;
    private Map<String, String> initParams;
    private boolean asyncSupported = this.getDefaultAsyncSupported();
    private static final String URL_PATTERN = "url-pattern";
    private static final String INIT_PARAM = "init-param";
    private static final String PARAM_NAME = "param-name";
    private static final String PARAM_VALUE = "param-value";

    public BaseServletModuleDescriptor(ModuleFactory moduleCreator) {
        super(moduleCreator);
    }

    public void init(@Nonnull Plugin plugin, @Nonnull Element element) {
        super.init(plugin, element);
        this.checkPermissions();
        List urlPatterns = element.elements(URL_PATTERN);
        this.paths = new ArrayList<String>(urlPatterns.size());
        for (Object urlPattern : urlPatterns) {
            this.paths.add(urlPattern.getTextTrim());
        }
        this.initParams = new HashMap<String, String>();
        List paramsList = element.elements(INIT_PARAM);
        for (Element initParamEl : paramsList) {
            Element paramNameEl = initParamEl.element(PARAM_NAME);
            Element paramValueEl = initParamEl.element(PARAM_VALUE);
            this.initParams.put(paramNameEl.getTextTrim(), paramValueEl.getTextTrim());
        }
        Element async = element.element("async-supported");
        if (async != null) {
            this.asyncSupported = Boolean.parseBoolean(async.getTextTrim());
        }
    }

    protected void validate(Element element) {
        super.validate(element);
        String exceptionMessage = "There were validation errors:";
        if (element.element(URL_PATTERN) == null) {
            throw new ValidationException(exceptionMessage, List.of("There must be at least one path specified"));
        }
        for (Element initParamElement : element.elements(INIT_PARAM)) {
            if (initParamElement.element(PARAM_NAME) == null) {
                throw new ValidationException(exceptionMessage, List.of(String.format("%s is required", PARAM_NAME)));
            }
            if (initParamElement.element(PARAM_VALUE) != null) continue;
            throw new ValidationException(exceptionMessage, List.of(String.format("%s is required", PARAM_VALUE)));
        }
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public Map<String, String> getInitParams() {
        return this.initParams;
    }

    public boolean isAsyncSupported() {
        return this.asyncSupported;
    }

    protected boolean getDefaultAsyncSupported() {
        return false;
    }
}

