/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.servlet;

import com.atlassian.plugin.servlet.descriptors.BaseServletModuleDescriptor;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginHttpRequestWrapper
extends HttpServletRequestWrapper {
    private final String basePath;

    public PluginHttpRequestWrapper(HttpServletRequest request, BaseServletModuleDescriptor<?> descriptor) {
        super(request);
        this.basePath = this.findBasePath(descriptor);
    }

    public String getServletPath() {
        String servletPath = super.getServletPath();
        if (this.basePath != null) {
            servletPath = servletPath + this.basePath;
        }
        return servletPath;
    }

    public String getPathInfo() {
        String pathInfo = super.getPathInfo();
        if (pathInfo != null && this.basePath != null) {
            if (this.basePath.equals(pathInfo)) {
                return null;
            }
            return pathInfo.substring(this.basePath.length());
        }
        return pathInfo;
    }

    private String findBasePath(BaseServletModuleDescriptor<?> descriptor) {
        String pathInfo = super.getPathInfo();
        if (pathInfo != null) {
            for (String basePath : descriptor.getPaths()) {
                if (this.isPathMapping(basePath)) {
                    if (!pathInfo.startsWith(this.getMappingRootPath(basePath))) continue;
                    return this.getMappingRootPath(basePath);
                }
                if (!basePath.equals(pathInfo)) continue;
                return basePath;
            }
        }
        return null;
    }

    private boolean isPathMapping(String path) {
        return path.startsWith("/") && path.endsWith("/*");
    }

    private String getMappingRootPath(String pathMapping) {
        return pathMapping.substring(0, pathMapping.length() - 2);
    }
}

