/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.schema.impl;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Permissions;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.descriptors.CannotDisable;
import com.atlassian.plugin.internal.schema.spi.DocumentBasedSchema;
import com.atlassian.plugin.internal.schema.spi.Schema;
import com.atlassian.plugin.internal.schema.spi.SchemaFactory;
import com.atlassian.plugin.internal.schema.spi.SchemaTransformer;
import com.atlassian.plugin.module.ContainerManagedPlugin;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.osgi.external.ListableModuleDescriptorFactory;
import com.atlassian.plugin.osgi.factory.OsgiPlugin;
import com.atlassian.plugin.schema.descriptor.DescribedModuleDescriptorFactory;
import com.atlassian.plugin.schema.impl.DescribedModuleTypeDescribedModuleDescriptorFactory;
import com.atlassian.plugin.util.resource.AlternativeResourceLoader;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.osgi.framework.BundleContext;

@CannotDisable
public final class DescribedModuleTypeModuleDescriptor
extends AbstractModuleDescriptor<DescribedModuleDescriptorFactory> {
    private static final String[] PUBLIC_INTERFACES = new String[]{ModuleDescriptorFactory.class.getName(), ListableModuleDescriptorFactory.class.getName(), DescribedModuleDescriptorFactory.class.getName()};
    private String schemaFactoryClassName;
    private String type;
    private String schemaTransformerClassName;
    private String maxOccurs;
    private Iterable<String> requiredPermissions;
    private Iterable<String> optionalPermissions;
    private static final String ERROR_MESSAGE_TEMPLATE = "Described module types can only be declared in OSGi Plugins, %s is not such a plugin";

    public DescribedModuleTypeModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public void init(@Nonnull Plugin plugin, @Nonnull Element element) {
        Preconditions.checkState((boolean)(plugin instanceof OsgiPlugin), (String)ERROR_MESSAGE_TEMPLATE, (Object)plugin.getKey());
        super.init(plugin, element);
        this.type = DescribedModuleTypeModuleDescriptor.getOptionalAttribute(element, "type", this.getKey());
        this.schemaFactoryClassName = DescribedModuleTypeModuleDescriptor.getOptionalAttribute(element, "schema-factory-class", null);
        this.schemaTransformerClassName = DescribedModuleTypeModuleDescriptor.getOptionalAttribute(element, "schema-transformer-class", null);
        this.maxOccurs = DescribedModuleTypeModuleDescriptor.getOptionalAttribute(element, "max-occurs", "unbounded");
        this.requiredPermissions = DescribedModuleTypeModuleDescriptor.getPermissions(element.element("required-permissions"));
        this.optionalPermissions = DescribedModuleTypeModuleDescriptor.getPermissions(element.element("optional-permissions"));
    }

    private static Iterable<String> getPermissions(Element element) {
        return Optional.ofNullable(element).map(e -> Iterables.transform((Iterable)e.elements("permission"), Element::getTextTrim)).orElseGet(Collections::emptyList);
    }

    public void enabled() {
        Preconditions.checkState((boolean)(this.plugin instanceof OsgiPlugin), (String)ERROR_MESSAGE_TEMPLATE, (Object)this.plugin.getKey());
        super.enabled();
        SchemaTransformer schemaTransformer = this.schemaTransformerClassName != null ? this.create(this.findClass(this.schemaTransformerClassName, SchemaTransformer.class)) : SchemaTransformer.IDENTITY;
        Class<ModuleDescriptor> moduleClass = this.findClass(this.moduleClassName, ModuleDescriptor.class);
        SchemaFactory schemaFactory = this.schemaFactoryClassName != null ? this.create(this.findClass(this.schemaFactoryClassName, SchemaFactory.class)) : this.buildSingleton(DocumentBasedSchema.builder(this.type).setResourceLoader(new AlternativePluginResourceLoader(this.plugin)).setName(this.getDisplayName()).setDescription(this.getDescription() != null ? this.getDescription() : "").setTransformer(schemaTransformer).setMaxOccurs(this.maxOccurs).setRequiredPermissions(this.getModuleRequiredPermissions(moduleClass)).setOptionalPermissions(this.optionalPermissions).build());
        DescribedModuleTypeDescribedModuleDescriptorFactory<ModuleDescriptor> factory = new DescribedModuleTypeDescribedModuleDescriptorFactory<ModuleDescriptor>((ContainerManagedPlugin)this.plugin, this.type, moduleClass, schemaFactory);
        this.getBundleContext().registerService(PUBLIC_INTERFACES, factory, null);
    }

    private Iterable<String> getModuleRequiredPermissions(Class<? extends ModuleDescriptor> moduleClass) {
        return ImmutableSet.builder().addAll(this.requiredPermissions).addAll((Iterable)Permissions.getRequiredPermissions(moduleClass)).build();
    }

    private BundleContext getBundleContext() {
        return ((OsgiPlugin)this.plugin).getBundle().getBundleContext();
    }

    private <T> T create(Class<? extends T> type) {
        return (T)((ContainerManagedPlugin)this.plugin).getContainerAccessor().createBean(type);
    }

    private <T> Class<? extends T> findClass(String className, Class<T> castTo) {
        Class clazz;
        Preconditions.checkNotNull((Object)className);
        try {
            clazz = this.plugin.loadClass(className, ((Object)((Object)this)).getClass());
        }
        catch (ClassNotFoundException e) {
            throw new PluginParseException("Unable to find class " + className);
        }
        return clazz.asSubclass(castTo);
    }

    public DescribedModuleDescriptorFactory getModule() {
        return (DescribedModuleDescriptorFactory)this.moduleFactory.createModule(this.moduleClassName, (ModuleDescriptor)this);
    }

    private SchemaFactory buildSingleton(Schema schema) {
        return () -> schema;
    }

    public static String getOptionalAttribute(Element e, String name, Object defaultValue) {
        String value = e.attributeValue(name);
        if (value != null) {
            return value;
        }
        return Objects.toString(defaultValue, null);
    }

    private static final class AlternativePluginResourceLoader
    implements AlternativeResourceLoader {
        private final Plugin plugin;

        public AlternativePluginResourceLoader(Plugin plugin) {
            this.plugin = (Plugin)Preconditions.checkNotNull((Object)plugin);
        }

        public URL getResource(String path) {
            return this.plugin.getResource(path);
        }

        public InputStream getResourceAsStream(String name) {
            return this.plugin.getResourceAsStream(name);
        }
    }
}

