/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.schema.spi;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.schema.spi.IdUtils;
import com.atlassian.plugin.schema.spi.Schema;
import com.atlassian.plugin.schema.spi.SchemaTransformer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class DocumentBasedSchema
implements Schema {
    private final String name;
    private final String description;
    private final String path;
    private final String elementName;
    private final String fileName;
    private final String complexType;
    private final String maxOccurs;
    private final Iterable<String> requiredPermissions;
    private final Iterable<String> optionalPermissions;
    private final Plugin plugin;
    private final SchemaTransformer schemaTransformer;
    private static InputSource EMPTY_INPUT_SOURCE = new InputSource(new ByteArrayInputStream(new byte[0]));
    private static final EntityResolver EMPTY_ENTITY_RESOLVER = new EntityResolver(){

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return EMPTY_INPUT_SOURCE;
        }
    };

    private DocumentBasedSchema(String elementName, String name, String description, String path, String fileName, String complexType, String maxOccurs, Iterable<String> requiredPermissions, Iterable<String> optionalPermissions, Plugin plugin, SchemaTransformer schemaTransformer) {
        this.name = name;
        this.elementName = elementName;
        this.description = description;
        this.path = path;
        this.fileName = fileName;
        this.complexType = complexType;
        this.maxOccurs = maxOccurs;
        this.requiredPermissions = requiredPermissions;
        this.optionalPermissions = optionalPermissions;
        this.plugin = plugin;
        this.schemaTransformer = schemaTransformer;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public String getElementName() {
        return this.elementName;
    }

    @Override
    public String getComplexType() {
        return this.complexType;
    }

    @Override
    public String getMaxOccurs() {
        return this.maxOccurs;
    }

    @Override
    public Iterable<String> getRequiredPermissions() {
        return this.requiredPermissions;
    }

    @Override
    public Iterable<String> getOptionalPermissions() {
        return this.optionalPermissions;
    }

    @Override
    public Document getDocument() {
        URL sourceUrl = this.plugin.getResource(this.path);
        if (sourceUrl == null) {
            throw new IllegalStateException("Cannot find schema document " + this.path);
        }
        Document source = DocumentBasedSchema.parseDocument(sourceUrl);
        return this.schemaTransformer.transform(source);
    }

    public static DynamicSchemaBuilder builder() {
        return new DynamicSchemaBuilder();
    }

    public static DynamicSchemaBuilder builder(String id) {
        return new DynamicSchemaBuilder(id);
    }

    private static Document parseDocument(URL xmlUrl) {
        Document source;
        try {
            source = DocumentBasedSchema.createSecureSaxReader().read(xmlUrl);
        }
        catch (DocumentException e) {
            throw new IllegalArgumentException("Unable to parse XML", e);
        }
        return source;
    }

    public static SAXReader createSecureSaxReader() {
        return DocumentBasedSchema.createReader(false);
    }

    private static SAXReader createReader(boolean validating) {
        XMLReader xmlReader;
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            spf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            xmlReader = spf.newSAXParser().getXMLReader();
            xmlReader.setEntityResolver(EMPTY_ENTITY_RESOLVER);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("XML Parser configured incorrectly", e);
        }
        catch (SAXException e) {
            throw new RuntimeException("Unable to configure XML parser", e);
        }
        return new SAXReader(xmlReader, validating);
    }

    public static class DynamicSchemaBuilder {
        private String name;
        private String description;
        private String path;
        private String fileName;
        private String elementName;
        private String complexType;
        private String maxOccurs = "unbounded";
        private Iterable<String> requiredPermissions = ImmutableSet.of((Object)"execute_java", (Object)"generate_any_html");
        private Iterable<String> optionalPermissions = Collections.emptySet();
        private Plugin plugin;
        private SchemaTransformer schemaTransformer = SchemaTransformer.IDENTITY;

        public DynamicSchemaBuilder() {
        }

        public DynamicSchemaBuilder(String elementName) {
            this.elementName = elementName;
            this.fileName = elementName + ".xsd";
            this.path = "/xsd/" + this.fileName;
            this.complexType = IdUtils.dashesToCamelCase(elementName) + "Type";
            this.name = IdUtils.dashesToTitle(elementName);
            this.description = "A " + this.name + " module";
        }

        public DynamicSchemaBuilder setName(String name) {
            this.name = name;
            return this;
        }

        public DynamicSchemaBuilder setDescription(String description) {
            this.description = description;
            return this;
        }

        public DynamicSchemaBuilder setPath(String path) {
            this.path = path;
            return this;
        }

        public DynamicSchemaBuilder setFileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public DynamicSchemaBuilder setElementName(String elementName) {
            this.elementName = elementName;
            return this;
        }

        public DynamicSchemaBuilder setRequiredPermissions(Iterable<String> permissions) {
            this.requiredPermissions = permissions;
            return this;
        }

        public DynamicSchemaBuilder setOptionalPermissions(Iterable<String> permissions) {
            this.optionalPermissions = permissions;
            return this;
        }

        public DynamicSchemaBuilder setComplexType(String complexType) {
            this.complexType = complexType;
            return this;
        }

        public DynamicSchemaBuilder setMaxOccurs(String maxOccurs) {
            this.maxOccurs = maxOccurs;
            return this;
        }

        public DynamicSchemaBuilder setPlugin(Plugin plugin) {
            this.plugin = plugin;
            return this;
        }

        public DynamicSchemaBuilder setTransformer(SchemaTransformer schemaTransformer) {
            this.schemaTransformer = schemaTransformer;
            return this;
        }

        public DocumentBasedSchema build() {
            Preconditions.checkNotNull((Object)this.elementName);
            Preconditions.checkNotNull((Object)this.fileName);
            Preconditions.checkNotNull((Object)this.name);
            Preconditions.checkNotNull((Object)this.description);
            Preconditions.checkNotNull((Object)this.complexType);
            Preconditions.checkNotNull((Object)this.plugin);
            Preconditions.checkNotNull(this.requiredPermissions);
            Preconditions.checkNotNull(this.optionalPermissions);
            return new DocumentBasedSchema(this.elementName, this.name, this.description, this.path, this.fileName, this.complexType, this.maxOccurs, this.requiredPermissions, this.optionalPermissions, this.plugin, this.schemaTransformer);
        }
    }
}

