/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.schema.impl;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.descriptors.CannotDisable;
import com.atlassian.plugin.hostcontainer.HostContainer;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.osgi.external.ListableModuleDescriptorFactory;
import com.atlassian.plugin.osgi.factory.OsgiPlugin;
import com.atlassian.plugin.schema.descriptor.DescribedModuleDescriptorFactory;
import com.atlassian.plugin.schema.impl.DefaultDescribedModuleDescriptorFactory;
import com.atlassian.plugin.schema.spi.DocumentBasedSchema;
import com.atlassian.plugin.schema.spi.Schema;
import com.atlassian.plugin.schema.spi.SchemaFactory;
import com.atlassian.plugin.schema.spi.SchemaTransformer;
import com.atlassian.util.concurrent.NotNull;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.dom4j.Element;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

@CannotDisable
public class DescribedModuleTypeModuleDescriptor
extends AbstractModuleDescriptor<DescribedModuleDescriptorFactory> {
    private static final String[] PUBLIC_INTERFACES = new String[]{ModuleDescriptorFactory.class.getName(), ListableModuleDescriptorFactory.class.getName(), DescribedModuleDescriptorFactory.class.getName()};
    private final HostContainer hostContainer;
    private final BundleContext bundleContext;
    private String schemaFactoryClassName;
    private String type;
    private String schemaTransformerClassName;
    private String maxOccurs;
    private Iterable<String> requiredPermissions;
    private Iterable<String> optionalPermissions;

    public DescribedModuleTypeModuleDescriptor(HostContainer hostContainer, BundleContext bundleContext) {
        super(ModuleFactory.LEGACY_MODULE_FACTORY);
        this.hostContainer = hostContainer;
        this.bundleContext = bundleContext;
    }

    public void init(@NotNull Plugin plugin, @NotNull Element element) throws PluginParseException {
        super.init(plugin, element);
        this.type = DescribedModuleTypeModuleDescriptor.getOptionalAttribute(element, "type", this.getKey());
        this.schemaFactoryClassName = DescribedModuleTypeModuleDescriptor.getOptionalAttribute(element, "schema-factory-class", null);
        this.schemaTransformerClassName = DescribedModuleTypeModuleDescriptor.getOptionalAttribute(element, "schema-transformer-class", null);
        this.maxOccurs = DescribedModuleTypeModuleDescriptor.getOptionalAttribute(element, "max-occurs", "unbounded");
        this.requiredPermissions = this.getPermissions(element.element("required-permissions"));
        this.optionalPermissions = this.getPermissions(element.element("optional-permissions"));
    }

    private Iterable<String> getPermissions(Element element) {
        if (element != null) {
            return Lists.transform((List)element.elements("permission"), (Function)new Function<Element, String>(){

                public String apply(Element input) {
                    return input.getTextTrim();
                }
            });
        }
        return Collections.emptyList();
    }

    public void enabled() {
        SchemaTransformer schemaTransformer;
        super.enabled();
        Bundle bundle = DescribedModuleTypeModuleDescriptor.findBundleForPlugin(this.bundleContext, this.getPluginKey());
        Preconditions.checkNotNull((Object)bundle, (Object)("Cannot find bundle for plugin " + this.getPluginKey()));
        SchemaTransformer schemaTransformer2 = schemaTransformer = this.schemaTransformerClassName != null ? (SchemaTransformer)this.hostContainer.create(this.findClass(this.schemaTransformerClassName, SchemaTransformer.class)) : SchemaTransformer.IDENTITY;
        SchemaFactory schemaFactory = this.schemaFactoryClassName != null ? (SchemaFactory)this.hostContainer.create(this.findClass(this.schemaFactoryClassName, SchemaFactory.class)) : this.buildSingleton(DocumentBasedSchema.builder(this.type).setPlugin(this.getPlugin()).setName(this.getName() != null ? this.getName() : this.getKey()).setDescription(this.getDescription() != null ? this.getDescription() : "").setTransformer(schemaTransformer).setMaxOccurs(this.maxOccurs).setRequiredPermissions(this.requiredPermissions).setOptionalPermissions(this.optionalPermissions).build());
        DefaultDescribedModuleDescriptorFactory<ModuleDescriptor> factory = new DefaultDescribedModuleDescriptorFactory<ModuleDescriptor>((OsgiPlugin)this.plugin, this.type, this.findClass(this.moduleClassName, ModuleDescriptor.class), schemaFactory);
        bundle.getBundleContext().registerService(PUBLIC_INTERFACES, factory, null);
    }

    private <T> Class<? extends T> findClass(String className, Class<T> castTo) {
        Preconditions.checkNotNull((Object)className);
        Class clazz = null;
        try {
            clazz = this.plugin.loadClass(className, ((Object)((Object)this)).getClass());
        }
        catch (ClassNotFoundException e) {
            throw new PluginParseException("Unable to find class " + className);
        }
        return clazz.asSubclass(castTo);
    }

    public DescribedModuleDescriptorFactory getModule() {
        return (DescribedModuleDescriptorFactory)this.moduleFactory.createModule(this.moduleClassName, (ModuleDescriptor)this);
    }

    private SchemaFactory buildSingleton(final Schema schema) {
        return new SchemaFactory(){

            @Override
            public Schema getSchema() {
                return schema;
            }
        };
    }

    private static Bundle findBundleForPlugin(BundleContext bundleContext, String pluginKey) {
        for (Bundle bundle : bundleContext.getBundles()) {
            String maybePluginKey = (String)bundle.getHeaders().get("Atlassian-Plugin-Key");
            if (!pluginKey.equals(maybePluginKey)) continue;
            return bundle;
        }
        return null;
    }

    public static String getOptionalAttribute(Element e, String name, Object defaultValue) {
        String value = e.attributeValue(name);
        return value != null ? value : (defaultValue != null ? defaultValue.toString() : null);
    }
}

