/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.refimpl;

import com.atlassian.plugin.manager.DefaultPluginPersistentState;
import com.atlassian.plugin.manager.PluginPersistentState;
import com.atlassian.plugin.manager.PluginPersistentStateStore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class DefaultPluginPersistentStateStore
implements PluginPersistentStateStore {
    private static final Logger log = Logger.getLogger(DefaultPluginPersistentStateStore.class);
    private File file;

    public DefaultPluginPersistentStateStore(File directory) {
        try {
            this.file = new File(directory.getParentFile(), "plugins.state");
            if (!this.file.exists()) {
                this.file.createNewFile();
            }
        }
        catch (IOException e) {
            log.error((Object)("Error creating plugins.state file. " + e), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluginPersistentState load() {
        HashMap<String, Boolean> state = new HashMap<String, Boolean>();
        FileInputStream inputStream = null;
        try {
            Properties properties = new Properties();
            inputStream = new FileInputStream(this.file);
            properties.load(inputStream);
            Set<Object> keys = properties.keySet();
            for (Object key : keys) {
                state.put(String.valueOf(key), Boolean.valueOf(String.valueOf(properties.get(key))));
            }
        }
        catch (IOException e) {
            try {
                log.error((Object)("Error creating/reading plugins.state file. " + e), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return new DefaultPluginPersistentState(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(PluginPersistentState state) {
        Properties properties = new Properties();
        Set entrySet = state.getMap().entrySet();
        for (Map.Entry entry : entrySet) {
            properties.put(entry.getKey(), String.valueOf(entry.getValue()));
        }
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(this.file);
            properties.store(outputStream, "Saving plugins state");
        }
        catch (IOException e) {
            try {
                log.error((Object)("Error saving to plugins.state file. " + e), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
    }
}

